/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.NodeJSWrapper;
import com.diffplug.spotless.npm.NpmConfig;
import com.diffplug.spotless.npm.NpmExecutableResolver;
import com.diffplug.spotless.npm.PlatformInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class NpmFormatterStepStateBase
implements Serializable {
    private static final long serialVersionUID = -5849375492831208496L;
    private final JarState jarState;
    private final FileSignature nodeModulesSignature;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    public final transient File nodeModulesDir;
    private final NpmConfig npmConfig;
    private final String stepName;

    protected NpmFormatterStepStateBase(String stepName, Provisioner provisioner, NpmConfig npmConfig, File buildDir, @Nullable File npm) throws IOException {
        this.stepName = Objects.requireNonNull(stepName);
        this.npmConfig = Objects.requireNonNull(npmConfig);
        this.jarState = JarState.from(NpmFormatterStepStateBase.j2v8MavenCoordinate(), Objects.requireNonNull(provisioner));
        this.nodeModulesDir = this.prepareNodeModules(buildDir, npm);
        this.nodeModulesSignature = FileSignature.signAsList(this.nodeModulesDir);
    }

    private File prepareNodeModules(File buildDir, @Nullable File npm) throws IOException {
        File targetDir = new File(buildDir, "spotless-node-modules-" + this.stepName);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new IOException("cannot create temp dir for node modules at " + targetDir);
        }
        File packageJsonFile = new File(targetDir, "package.json");
        Files.write(packageJsonFile.toPath(), this.npmConfig.getPackageJsonContent().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        this.runNpmInstall(npm, targetDir);
        return targetDir;
    }

    private void runNpmInstall(@Nullable File npm, File npmProjectDir) throws IOException {
        Process npmInstall = new ProcessBuilder(new String[0]).inheritIO().directory(npmProjectDir).command(this.resolveNpm(npm).getAbsolutePath(), "install").start();
        try {
            if (npmInstall.waitFor() != 0) {
                throw new IOException("Creating npm modules failed with exit code: " + npmInstall.exitValue());
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Running npm install was interrupted.", e);
        }
    }

    private File resolveNpm(@Nullable File npm) {
        return Optional.ofNullable(npm).orElseGet(() -> NpmExecutableResolver.tryFind().orElseThrow(() -> new IllegalStateException("cannot automatically determine npm executable and none was specifically supplied!")));
    }

    protected NodeJSWrapper nodeJSWrapper() {
        return new NodeJSWrapper(this.jarState.getClassLoader());
    }

    protected File nodeModulePath() {
        return new File(new File(this.nodeModulesDir, "node_modules"), this.npmConfig.getNpmModule());
    }

    static String j2v8MavenCoordinate() {
        return "com.eclipsesource.j2v8:j2v8_" + PlatformInfo.normalizedOSName() + "_" + PlatformInfo.normalizedArchName() + ":4.6.0";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String readFileFromClasspath(Class<?> clazz, String name) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (InputStream input = clazz.getResourceAsStream(name);){
            int numRead;
            byte[] buffer = new byte[1024];
            while ((numRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, numRead);
            }
            String string = output.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    protected static String replaceDevDependencies(String template, Map<String, String> devDependencies) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> entryIter = devDependencies.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<String, String> entry = entryIter.next();
            builder.append("\t\t\"");
            builder.append(entry.getKey());
            builder.append("\": \"");
            builder.append(entry.getValue());
            builder.append("\"");
            if (!entryIter.hasNext()) continue;
            builder.append(",\n");
        }
        return NpmFormatterStepStateBase.replacePlaceholders(template, Collections.singletonMap("devDependencies", builder.toString()));
    }

    private static String replacePlaceholders(String template, Map<String, String> replacements) {
        String result = template;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            result = result.replaceAll("\\Q${" + entry.getKey() + "}\\E", entry.getValue());
        }
        return result;
    }

    public abstract FormatterFunc createFormatterFunc();
}

