/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class NpmProcess {
    private final File workingDir;
    private final File npmExecutable;

    NpmProcess(File workingDir, File npmExecutable) {
        this.workingDir = workingDir;
        this.npmExecutable = npmExecutable;
    }

    void install() {
        this.npmAwait("install", "--no-audit", "--no-package-lock");
    }

    Process start() {
        return this.npm("start");
    }

    private void npmAwait(String ... args) {
        Process npmProcess = this.npm(args);
        try {
            if (npmProcess.waitFor() != 0) {
                throw new NpmProcessException("Running npm command '" + this.commandLine(args) + "' failed with exit code: " + npmProcess.exitValue());
            }
        }
        catch (InterruptedException e) {
            throw new NpmProcessException("Running npm command '" + this.commandLine(args) + "' was interrupted.", e);
        }
    }

    private Process npm(String ... args) {
        List<String> processCommand = this.processCommand(args);
        try {
            return new ProcessBuilder(new String[0]).inheritIO().directory(this.workingDir).command(processCommand).start();
        }
        catch (IOException e) {
            throw new NpmProcessException("Failed to launch npm command '" + this.commandLine(args) + "'.", e);
        }
    }

    private List<String> processCommand(String ... args) {
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add(this.npmExecutable.getAbsolutePath());
        command.addAll(Arrays.asList(args));
        return command;
    }

    private String commandLine(String ... args) {
        return "npm " + Arrays.stream(args).collect(Collectors.joining(" "));
    }

    static class NpmProcessException
    extends RuntimeException {
        public NpmProcessException(String message) {
            super(message);
        }

        public NpmProcessException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

