/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Provisioner;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;

public class GoogleJavaFormatStep {
    private static final String DEFAULT_VERSION = "1.3";
    static final String NAME = "google-java-format";
    static final String MAVEN_COORDINATE = "com.google.googlejavaformat:google-java-format:";
    static final String FORMATTER_CLASS = "com.google.googlejavaformat.java.Formatter";
    static final String FORMATTER_METHOD = "formatSource";
    private static final String REMOVE_UNUSED_CLASS = "com.google.googlejavaformat.java.RemoveUnusedImports";
    private static final String REMOVE_UNUSED_METHOD = "removeUnusedImports";
    private static final String REMOVE_UNUSED_IMPORT_JavadocOnlyImports = "com.google.googlejavaformat.java.RemoveUnusedImports$JavadocOnlyImports";
    private static final String REMOVE_UNUSED_IMPORT_JavadocOnlyImports_Keep = "KEEP";
    private static final String IMPORT_ORDERER_CLASS = "com.google.googlejavaformat.java.ImportOrderer";
    private static final String IMPORT_ORDERER_METHOD = "reorderImports";
    private static final boolean IS_WINDOWS = LineEnding.PLATFORM_NATIVE.str().equals("\r\n");

    private GoogleJavaFormatStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return GoogleJavaFormatStep.create(GoogleJavaFormatStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(NAME, version, provisioner), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static String fixWindowsBug(String input, String version) {
        if (IS_WINDOWS && version.equals("1.1")) {
            int firstImport = input.indexOf("\nimport ");
            if (firstImport == 0) {
                return input;
            }
            if (firstImport > 0) {
                char prevChar;
                int numToTrim = 0;
                while (Character.isWhitespace(prevChar = input.charAt(firstImport - ++numToTrim)) && firstImport - numToTrim > 0) {
                }
                if (firstImport - numToTrim == 0) {
                    ++numToTrim;
                } else if (prevChar == ';' || prevChar == '/') {
                    --numToTrim;
                }
                if (numToTrim > 0) {
                    return input.substring(0, firstImport - numToTrim + 2) + input.substring(firstImport + 1);
                }
            }
        }
        return input;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final String stepName;
        final String version;

        State(String stepName, String version, Provisioner provisioner) throws IOException {
            this.jarState = JarState.from(GoogleJavaFormatStep.MAVEN_COORDINATE + version, provisioner);
            this.stepName = stepName;
            this.version = version;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterClazz = classLoader.loadClass(GoogleJavaFormatStep.FORMATTER_CLASS);
            Object formatter = formatterClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method formatterMethod = formatterClazz.getMethod(GoogleJavaFormatStep.FORMATTER_METHOD, String.class);
            Class<?> removeUnusedClass = classLoader.loadClass(GoogleJavaFormatStep.REMOVE_UNUSED_CLASS);
            Class<?> removeJavadocOnlyClass = classLoader.loadClass(GoogleJavaFormatStep.REMOVE_UNUSED_IMPORT_JavadocOnlyImports);
            Object removeJavadocConstant = Enum.valueOf(removeJavadocOnlyClass, GoogleJavaFormatStep.REMOVE_UNUSED_IMPORT_JavadocOnlyImports_Keep);
            Method removeUnusedMethod = removeUnusedClass.getMethod(GoogleJavaFormatStep.REMOVE_UNUSED_METHOD, String.class, removeJavadocOnlyClass);
            Class<?> importOrdererClass = classLoader.loadClass(GoogleJavaFormatStep.IMPORT_ORDERER_CLASS);
            Method importOrdererMethod = importOrdererClass.getMethod(GoogleJavaFormatStep.IMPORT_ORDERER_METHOD, String.class);
            return input -> {
                String formatted = (String)formatterMethod.invoke(formatter, input);
                String removedUnused = (String)removeUnusedMethod.invoke(null, formatted, removeJavadocConstant);
                String sortedImports = (String)importOrdererMethod.invoke(null, removedUnused);
                return GoogleJavaFormatStep.fixWindowsBug(sortedImports, this.version);
            };
        }

        FormatterFunc createRemoveUnusedImportsOnly() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> removeUnusedClass = classLoader.loadClass(GoogleJavaFormatStep.REMOVE_UNUSED_CLASS);
            Class<?> removeJavadocOnlyClass = classLoader.loadClass(GoogleJavaFormatStep.REMOVE_UNUSED_IMPORT_JavadocOnlyImports);
            Object removeJavadocConstant = Enum.valueOf(removeJavadocOnlyClass, GoogleJavaFormatStep.REMOVE_UNUSED_IMPORT_JavadocOnlyImports_Keep);
            Method removeUnusedMethod = removeUnusedClass.getMethod(GoogleJavaFormatStep.REMOVE_UNUSED_METHOD, String.class, removeJavadocOnlyClass);
            return input -> {
                String removeUnused = (String)removeUnusedMethod.invoke(null, input, removeJavadocConstant);
                return GoogleJavaFormatStep.fixWindowsBug(removeUnused, this.version);
            };
        }
    }
}

