/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.NoLambda;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public enum LineEnding {
    GIT_ATTRIBUTES{

        @Override
        @Deprecated
        public Policy createPolicy() {
            return super.createPolicy();
        }
    }
    ,
    PLATFORM_NATIVE,
    WINDOWS,
    UNIX;

    @Nullable
    private static volatile BiFunction<File, Supplier<Iterable<File>>, Policy> gitAttributesPolicyCreator;
    private static final Policy WINDOWS_POLICY;
    private static final Policy UNIX_POLICY;
    private static final String _platformNative;
    private static final Policy _platformNativePolicy;
    private static final boolean nativeIsWin;

    public Policy createPolicy(File projectDir, Supplier<Iterable<File>> toFormat) {
        Objects.requireNonNull(projectDir, "projectDir");
        Objects.requireNonNull(toFormat, "toFormat");
        if (this != GIT_ATTRIBUTES) {
            return this.createPolicy();
        }
        if (gitAttributesPolicyCreator == null) {
            try {
                Class<?> clazz = Class.forName("com.diffplug.spotless.extra.GitAttributesLineEndings");
                Method method = clazz.getMethod("create", File.class, Supplier.class);
                gitAttributesPolicyCreator = (proj, target) -> ThrowingEx.get(() -> LineEnding.lambda$null$0(method, proj, (Supplier)target));
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException("LineEnding.GIT_ATTRIBUTES requires the spotless-lib-extra library, but it is not on the classpath", e);
            }
        }
        return gitAttributesPolicyCreator.apply(projectDir, toFormat);
    }

    public Policy createPolicy() {
        switch (this) {
            case PLATFORM_NATIVE: {
                return _platformNativePolicy;
            }
            case WINDOWS: {
                return WINDOWS_POLICY;
            }
            case UNIX: {
                return UNIX_POLICY;
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this) + " is a path-specific line ending.");
    }

    public static boolean nativeIsWin() {
        return nativeIsWin;
    }

    public String str() {
        switch (this) {
            case PLATFORM_NATIVE: {
                return _platformNative;
            }
            case WINDOWS: {
                return "\r\n";
            }
            case UNIX: {
                return "\n";
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this) + " is a path-specific line ending.");
    }

    public static String toUnix(String input) {
        int firstNewline = input.lastIndexOf(10);
        if (firstNewline == -1) {
            return input;
        }
        return input.replace("\r", "");
    }

    private static /* synthetic */ Policy lambda$null$0(Method method, File proj, Supplier target) throws Exception {
        return (Policy)method.invoke(null, proj, target);
    }

    static {
        WINDOWS_POLICY = new ConstantLineEndingPolicy(WINDOWS.str());
        UNIX_POLICY = new ConstantLineEndingPolicy(UNIX.str());
        _platformNative = System.getProperty("line.separator");
        _platformNativePolicy = new ConstantLineEndingPolicy(_platformNative);
        nativeIsWin = _platformNative.equals(WINDOWS.str());
    }

    public static interface Policy
    extends Serializable,
    NoLambda {
        public String getEndingFor(File var1);

        default public boolean isUnix(File file) {
            Objects.requireNonNull(file);
            String ending = this.getEndingFor(file);
            return ending.equals(UNIX.str());
        }
    }

    static class ConstantLineEndingPolicy
    extends NoLambda.EqualityBasedOnSerialization
    implements Policy {
        private static final long serialVersionUID = 1L;
        final String lineEnding;

        ConstantLineEndingPolicy(String lineEnding) {
            this.lineEnding = lineEnding;
        }

        @Override
        public String getEndingFor(File file) {
            return this.lineEnding;
        }
    }
}

