/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class KtfmtStep {
    private static final String DEFAULT_VERSION = "0.15";
    static final String NAME = "ktfmt";
    static final String PACKAGE = "com.facebook";
    static final String MAVEN_COORDINATE = "com.facebook:ktfmt:";
    private static final int MAX_WIDTH_LINE = 100;
    private static final int BLOCK_INDENT = 4;
    private static final int CONTINUATION_INDENT = 4;
    static final String FORMATTER_METHOD = "format";

    private KtfmtStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtfmtStep.create(KtfmtStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtfmtStep.create(version, provisioner, Style.DEFAULT);
    }

    public static FormatterStep create(String version, Provisioner provisioner, Style style) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        Objects.requireNonNull(style, "style");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, style), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String pkg;
        private final Style style;
        final JarState jarState;

        State(String version, Provisioner provisioner, Style style) throws IOException {
            this.pkg = KtfmtStep.PACKAGE;
            this.style = style;
            this.jarState = JarState.from(KtfmtStep.MAVEN_COORDINATE + version, provisioner);
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterClazz = classLoader.loadClass(this.pkg + ".ktfmt.FormatterKt");
            return input -> {
                try {
                    if (this.style == Style.DROPBOX) {
                        Class<?> formattingOptionsClazz = classLoader.loadClass(this.pkg + ".ktfmt.FormattingOptions");
                        Object formattingOptions = formattingOptionsClazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(100, 4, 4);
                        Method formatterMethod = formatterClazz.getMethod(KtfmtStep.FORMATTER_METHOD, formattingOptionsClazz, String.class);
                        return (String)formatterMethod.invoke((Object)formatterClazz, formattingOptions, input);
                    }
                    Method formatterMethod = formatterClazz.getMethod(KtfmtStep.FORMATTER_METHOD, String.class);
                    return (String)formatterMethod.invoke((Object)formatterClazz, input);
                }
                catch (InvocationTargetException e) {
                    throw ThrowingEx.unwrapCause(e);
                }
            };
        }
    }

    public static enum Style {
        DEFAULT,
        DROPBOX;

    }
}

