/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterStepImpl;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.util.Objects;

@FunctionalInterface
public interface FormatterFunc {
    public String apply(String var1) throws Exception;

    default public String apply(String unix, File file) throws Exception {
        return this.apply(unix);
    }

    public static FormatterFunc needsFile(NeedsFile needsFile) {
        return needsFile;
    }

    @FunctionalInterface
    public static interface NeedsFile
    extends FormatterFunc {
        public String applyWithFile(String var1, File var2) throws Exception;

        @Override
        default public String apply(String unix, File file) throws Exception {
            if (file == FormatterStepImpl.SENTINEL) {
                throw new IllegalArgumentException("This step requires the underlying file. If this is a test, use StepHarnessWithFile");
            }
            return this.applyWithFile(unix, file);
        }

        @Override
        default public String apply(String unix) throws Exception {
            return this.apply(unix, FormatterStepImpl.SENTINEL);
        }
    }

    public static interface Closeable
    extends FormatterFunc,
    AutoCloseable {
        @Override
        public void close();

        public static Closeable of(final AutoCloseable closeable, final FormatterFunc function) {
            Objects.requireNonNull(closeable, "closeable");
            Objects.requireNonNull(function, "function");
            return new Closeable(){

                @Override
                public void close() {
                    ThrowingEx.run(closeable::close);
                }

                @Override
                public String apply(String unix, File file) throws Exception {
                    return function.apply(Objects.requireNonNull(unix), Objects.requireNonNull(file));
                }

                @Override
                public String apply(String unix) throws Exception {
                    return function.apply(Objects.requireNonNull(unix));
                }
            };
        }
    }
}

