/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktlint;

import com.diffplug.spotless.FormatterFunc;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.ruleset.experimental.ExperimentalRuleSetProvider;
import com.pinterest.ktlint.ruleset.standard.StandardRuleSetProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;

public class KtlintFormatterFunc
implements FormatterFunc.NeedsFile {
    private final List<RuleSet> rulesets = new ArrayList<RuleSet>();
    private final Map<String, String> userData;
    private final Function2<? super LintError, ? super Boolean, Unit> formatterCallback;
    private final boolean isScript;

    public KtlintFormatterFunc(boolean isScript, boolean useExperimental, Map<String, String> userData) {
        this.rulesets.add(new StandardRuleSetProvider().get());
        if (useExperimental) {
            this.rulesets.add(new ExperimentalRuleSetProvider().get());
        }
        this.userData = userData;
        this.formatterCallback = new FormatterCallback();
        this.isScript = isScript;
    }

    @Override
    public String applyWithFile(String unix, File file) throws Exception {
        return KtLint.INSTANCE.format(new KtLint.Params(file.getName(), unix, this.rulesets, this.userData, this.formatterCallback, this.isScript, null, false));
    }

    static class FormatterCallback
    implements Function2<LintError, Boolean, Unit> {
        FormatterCallback() {
        }

        public Unit invoke(LintError lint, Boolean corrected) {
            if (!corrected.booleanValue()) {
                throw new AssertionError((Object)("Error on line: " + lint.getLine() + ", column: " + lint.getCol() + "\n" + lint.getDetail()));
            }
            return null;
        }
    }
}

