/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.java.ModuleHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class PalantirJavaFormatStep {
    private static final String NAME = "palantir-java-format";
    private static final String MAVEN_COORDINATE = "com.palantir.javaformat:palantir-java-format:";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support("palantir-java-format").add(8, "1.1.0").add(11, "2.10.0");

    private PalantirJavaFormatStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return PalantirJavaFormatStep.create(PalantirJavaFormatStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(JarState.from(MAVEN_COORDINATE + version, provisioner), version), State::createFormat);
    }

    public static String defaultVersion() {
        return JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final String formatterVersion;

        State(JarState jarState, String formatterVersion) {
            ModuleHelper.doOpenInternalPackagesIfRequired();
            this.jarState = jarState;
            this.formatterVersion = formatterVersion;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.pjf.PalantirJavaFormatFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(new Class[0]);
            return JVM_SUPPORT.suggestLaterVersionOnError(this.formatterVersion, (FormatterFunc)constructor.newInstance(new Object[0]));
        }
    }
}

