/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.npm.JsonRawValue;
import com.diffplug.spotless.npm.SimpleJsonWriter;
import com.diffplug.spotless.npm.SimpleRestClient;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class PrettierRestService {
    private final SimpleRestClient restClient;

    PrettierRestService(String baseUrl) {
        this.restClient = SimpleRestClient.forBaseUrl(baseUrl);
    }

    public String resolveConfig(File prettierConfigPath, Map<String, Object> prettierConfigOptions) {
        LinkedHashMap<String, Object> jsonProperties = new LinkedHashMap<String, Object>();
        if (prettierConfigPath != null) {
            jsonProperties.put("prettier_config_path", prettierConfigPath.getAbsolutePath());
        }
        if (prettierConfigOptions != null) {
            jsonProperties.put("prettier_config_options", SimpleJsonWriter.of(prettierConfigOptions).toJsonRawValue());
        }
        return this.restClient.postJson("/prettier/config-options", jsonProperties);
    }

    public String format(String fileContent, String configOptionsJsonString) {
        LinkedHashMap<String, Object> jsonProperties = new LinkedHashMap<String, Object>();
        jsonProperties.put("file_content", fileContent);
        if (configOptionsJsonString != null) {
            jsonProperties.put("config_options", JsonRawValue.wrap(configOptionsJsonString));
        }
        return this.restClient.postJson("/prettier/format", jsonProperties);
    }

    public String shutdown() {
        return this.restClient.post("/shutdown");
    }
}

