/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json.gson;

import com.diffplug.spotless.JarState;
import com.diffplug.spotless.json.gson.GsonWrapperBase;
import com.diffplug.spotless.json.gson.JsonElementWrapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;

class JsonObjectWrapper
extends GsonWrapperBase {
    private final Constructor<?> constructor;
    private final Method keySetMethod;
    private final Method getMethod;
    private final Method addMethod;

    JsonObjectWrapper(JarState jarState, JsonElementWrapper jsonElementWrapper) {
        Class<?> clazz = this.loadClass(jarState.getClassLoader(), "com.google.gson.JsonObject");
        this.constructor = this.getConstructor(clazz, new Class[0]);
        this.keySetMethod = this.getMethod(clazz, "keySet", new Class[0]);
        this.getMethod = this.getMethod(clazz, "get", String.class);
        this.addMethod = this.getMethod(clazz, "add", String.class, jsonElementWrapper.getWrappedClass());
    }

    Object createJsonObject() {
        return this.newInstance(this.constructor, new Object[0]);
    }

    Set<String> keySet(Object jsonObject) {
        return (Set)this.invoke(this.keySetMethod, jsonObject, new Object[0]);
    }

    Object get(Object jsonObject, String key) {
        return this.invoke(this.getMethod, jsonObject, key);
    }

    void add(Object jsonObject, String key, Object element) {
        this.invoke(this.addMethod, jsonObject, key, element);
    }
}

