/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.json.JacksonConfig;
import com.diffplug.spotless.json.JacksonJsonConfig;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class JacksonJsonStep {
    static final String MAVEN_COORDINATE = "com.fasterxml.jackson.core:jackson-databind:";
    static final String DEFAULT_VERSION = "2.14.1";

    private JacksonJsonStep() {
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static FormatterStep create(JacksonJsonConfig jacksonConfig, String jacksonVersion, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.createLazy("json", () -> new State(jacksonConfig, jacksonVersion, provisioner), State::toFormatter);
    }

    public static FormatterStep create(Provisioner provisioner) {
        return JacksonJsonStep.create(new JacksonJsonConfig(), JacksonJsonStep.defaultVersion(), provisioner);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JacksonConfig jacksonConfig;
        private final JarState jarState;

        private State(JacksonConfig jacksonConfig, String jacksonVersion, Provisioner provisioner) throws IOException {
            this.jacksonConfig = jacksonConfig;
            this.jarState = JarState.from(JacksonJsonStep.MAVEN_COORDINATE + jacksonVersion, provisioner);
        }

        FormatterFunc toFormatter() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.json.JacksonJsonFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(JacksonJsonConfig.class);
            return (FormatterFunc)constructor.newInstance(this.jacksonConfig);
        }
    }
}

