/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.npm.FileFinder;
import com.diffplug.spotless.npm.PlatformInfo;
import java.io.File;
import java.util.Optional;
import java.util.function.Function;

class NpmExecutableResolver {
    private static final FileFinder NPM_EXECUTABLE_FINDER = FileFinder.finderForExecutableFilename(NpmExecutableResolver.npmExecutableName()).candidateSystemProperty("npm.exec").candidateEnvironmentPath("NVM_BIN").candidateEnvironmentPathList("NVM_SYMLINK", NpmExecutableResolver.resolveParentOfNodeModulesDir()).candidateEnvironmentPathList("NODE_PATH", NpmExecutableResolver.resolveParentOfNodeModulesDir()).candidateEnvironmentPathList("PATH", NpmExecutableResolver.resolveParentOfNodeModulesDir()).build();

    private NpmExecutableResolver() {
    }

    static String npmExecutableName() {
        String npmName = "npm";
        if (PlatformInfo.normalizedOS() == PlatformInfo.OS.WINDOWS) {
            npmName = npmName + ".cmd";
        }
        return npmName;
    }

    private static ParentOfNodeModulesDirResolver resolveParentOfNodeModulesDir() {
        return new ParentOfNodeModulesDirResolver();
    }

    static Optional<File> tryFind() {
        return NPM_EXECUTABLE_FINDER.tryFind();
    }

    static String explainMessage() {
        return "Spotless tries to find your npm executable automatically. It looks for npm in the following places:\n- An executable referenced by the java system property 'npm.exec' - if such a system property exists.\n- The environment variable 'NVM_BIN' - if such an environment variable exists.\n- The environment variable 'NVM_SYMLINK' - if such an environment variable exists.\n- The environment variable 'NODE_PATH' - if such an environment variable exists.\n- In your 'PATH' environment variable\n\nIf autodiscovery fails for your system, try to set one of the environment variables correctly or\ntry setting the system property 'npm.exec' in the build process to override autodiscovery.";
    }

    static class ParentOfNodeModulesDirResolver
    implements Function<File, File> {
        ParentOfNodeModulesDirResolver() {
        }

        @Override
        public File apply(File file) {
            if (file != null && file.isDirectory() && file.getName().equalsIgnoreCase("node_modules")) {
                return file.getParentFile();
            }
            return file;
        }
    }
}

