/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.java;

import com.diffplug.spotless.FormatterFunc;
import eu.solven.cleanthat.config.pojo.CleanthatEngineProperties;
import eu.solven.cleanthat.config.pojo.SourceCodeProperties;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorer;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorerProperties;
import eu.solven.cleanthat.formatter.LineEnding;
import eu.solven.cleanthat.language.IEngineProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCleanthatRefactorerFunc
implements FormatterFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaCleanthatRefactorerFunc.class);
    private String jdkVersion;
    private List<String> included;
    private List<String> excluded;

    public JavaCleanthatRefactorerFunc(String jdkVersion, List<String> included, List<String> excluded) {
        this.jdkVersion = jdkVersion == null ? "1.8" : jdkVersion;
        this.included = included == null ? Collections.emptyList() : included;
        this.excluded = excluded == null ? Collections.emptyList() : excluded;
    }

    public JavaCleanthatRefactorerFunc() {
        this("1.8", Arrays.asList("*"), Arrays.asList(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String apply(String input) throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String string = this.doApply(input);
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private String doApply(String input) throws InterruptedException, IOException {
        CleanthatEngineProperties engineProperties = CleanthatEngineProperties.builder().engineVersion(this.jdkVersion).build();
        engineProperties.setSourceCode(SourceCodeProperties.builder().lineEnding(LineEnding.LF).build());
        JavaRefactorerProperties refactorerProperties = new JavaRefactorerProperties();
        refactorerProperties.setIncluded(this.included);
        refactorerProperties.setExcluded(this.excluded);
        JavaRefactorer refactorer = new JavaRefactorer((IEngineProperties)engineProperties, refactorerProperties);
        LOGGER.debug("Processing sourceJdk={} included={} excluded={}", new Object[]{this.jdkVersion, this.included, this.excluded});
        LOGGER.debug("Available mutators: {}", (Object)JavaRefactorer.getAllIncluded());
        return refactorer.doFormat(input, LineEnding.LF);
    }
}

