/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ThrowingEx;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

final class NpmResourceHelper {
    private NpmResourceHelper() {
    }

    static void writeUtf8StringToFile(File file, String stringToWrite) throws IOException {
        Files.write(file.toPath(), stringToWrite.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    static void writeUtf8StringToOutputStream(String stringToWrite, OutputStream outputStream) throws IOException {
        byte[] bytes = stringToWrite.getBytes(StandardCharsets.UTF_8);
        outputStream.write(bytes);
    }

    static void deleteFileIfExists(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    static String readUtf8StringFromClasspath(Class<?> clazz, String ... resourceNames) {
        return Arrays.stream(resourceNames).map(resourceName -> NpmResourceHelper.readUtf8StringFromClasspath(clazz, resourceName)).collect(Collectors.joining("\n"));
    }

    static String readUtf8StringFromClasspath(Class<?> clazz, String resourceName) {
        String string;
        block8: {
            InputStream input = clazz.getResourceAsStream(resourceName);
            try {
                string = NpmResourceHelper.readUtf8StringFromInputStream(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ThrowingEx.asRuntime(e);
                }
            }
            input.close();
        }
        return string;
    }

    static String readUtf8StringFromFile(File file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file.toPath()));
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    static String readUtf8StringFromInputStream(InputStream input) {
        try {
            int numRead;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((numRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, numRead);
            }
            return output.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    static void assertDirectoryExists(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("cannot create temp dir for node modules at " + directory);
        }
    }

    static void awaitReadableFile(File file, Duration maxWaitTime) throws TimeoutException {
        long startedAt = System.currentTimeMillis();
        while (!file.exists() || !file.canRead()) {
            if (System.currentTimeMillis() - startedAt <= maxWaitTime.toMillis()) continue;
            throw new TimeoutException("The file did not appear within " + maxWaitTime);
        }
    }

    static File copyFileToDir(File file, File targetDir) {
        return NpmResourceHelper.copyFileToDirAtSubpath(file, targetDir, file.getName());
    }

    static File copyFileToDirAtSubpath(File file, File targetDir, String relativePath) {
        Objects.requireNonNull(relativePath);
        try {
            Path relativeTargetFile = Paths.get(targetDir.getAbsolutePath(), relativePath);
            NpmResourceHelper.assertDirectoryExists(relativeTargetFile.getParent().toFile());
            Files.copy(file.toPath(), relativeTargetFile, StandardCopyOption.REPLACE_EXISTING);
            return relativeTargetFile.toFile();
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    static String md5(File file) {
        return NpmResourceHelper.md5(NpmResourceHelper.readUtf8StringFromFile(file));
    }

    static String md5(String fileContent) {
        MessageDigest md = ThrowingEx.get(() -> MessageDigest.getInstance("MD5"));
        md.update(fileContent.getBytes(StandardCharsets.UTF_8));
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

