/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStepEqualityOnStateSerialization;
import com.diffplug.spotless.SerializedFunction;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

class FormatterStepSerializationRoundtrip<RoundtripState extends Serializable, EqualityState extends Serializable>
extends FormatterStepEqualityOnStateSerialization<EqualityState> {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final transient ThrowingEx.Supplier<RoundtripState> initializer;
    @Nullable
    private RoundtripState roundtripStateInternal;
    private final SerializedFunction<RoundtripState, EqualityState> equalityStateExtractor;
    private final SerializedFunction<EqualityState, FormatterFunc> equalityStateToFormatter;

    public FormatterStepSerializationRoundtrip(String name, ThrowingEx.Supplier<RoundtripState> initializer, SerializedFunction<RoundtripState, EqualityState> equalityStateExtractor, SerializedFunction<EqualityState, FormatterFunc> equalityStateToFormatter) {
        this.name = name;
        this.initializer = initializer;
        this.equalityStateExtractor = equalityStateExtractor;
        this.equalityStateToFormatter = equalityStateToFormatter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected EqualityState stateSupplier() throws Exception {
        if (this.roundtripStateInternal == null) {
            this.roundtripStateInternal = (Serializable)this.initializer.get();
        }
        return (EqualityState)((Serializable)this.equalityStateExtractor.apply(this.roundtripStateInternal));
    }

    @Override
    protected FormatterFunc stateToFormatter(EqualityState equalityState) throws Exception {
        return (FormatterFunc)this.equalityStateToFormatter.apply(equalityState);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.roundtripStateInternal == null) {
            this.roundtripStateInternal = ThrowingEx.get(this.initializer::get);
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new UnsupportedOperationException();
    }
}

