/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class KtLintStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_VERSION = "1.2.1";
    private static final String NAME = "ktlint";
    private static final String MAVEN_COORDINATE_0_DOT = "com.pinterest:ktlint:";
    private static final String MAVEN_COORDINATE_1_DOT = "com.pinterest.ktlint:ktlint-cli:";
    private final JarState.Promised jarState;
    @Nullable
    private final FileSignature.Promised config;
    private final Map<String, Object> editorConfigOverride;
    private final String version;

    private KtLintStep(String version, JarState.Promised jarState, @Nullable FileSignature config, Map<String, Object> editorConfigOverride) {
        this.version = version;
        this.jarState = jarState;
        this.config = config != null ? config.asPromise() : null;
        this.editorConfigOverride = editorConfigOverride;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtLintStep.create(KtLintStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, null, Collections.emptyMap(), Collections.emptyList());
    }

    public static FormatterStep create(String version, Provisioner provisioner, @Nullable FileSignature editorConfig, Map<String, Object> editorConfigOverride, List<String> customRuleSets) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        String ktlintCoordinate = (version.startsWith("0.") ? MAVEN_COORDINATE_0_DOT : MAVEN_COORDINATE_1_DOT) + version;
        HashSet<String> mavenCoordinates = new HashSet<String>(customRuleSets);
        mavenCoordinates.add(ktlintCoordinate);
        return FormatterStep.create(NAME, new KtLintStep(version, JarState.promise(() -> JarState.from(mavenCoordinates, provisioner)), editorConfig, editorConfigOverride), KtLintStep::equalityState, State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private State equalityState() {
        return new State(this.version, this.jarState.get(), this.config != null ? this.config.get() : null, this.editorConfigOverride);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final TreeMap<String, Object> editorConfigOverride;
        private final String version;
        @Nullable
        private final FileSignature editorConfigPath;

        State(String version, JarState jarState, @Nullable FileSignature editorConfigPath, Map<String, Object> editorConfigOverride) {
            this.version = version;
            this.jarState = jarState;
            this.editorConfigOverride = new TreeMap<String, Object>(editorConfigOverride);
            this.editorConfigPath = editorConfigPath;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.ktlint.KtlintFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class, FileSignature.class, Map.class);
            return (FormatterFunc.NeedsFile)constructor.newInstance(this.version, this.editorConfigPath, this.editorConfigOverride);
        }
    }
}

