/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LibPreconditions;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Formatter
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 1L;
    private String name;
    private LineEnding.Policy lineEndingsPolicy;
    private Charset encoding;
    private Path rootDir;
    private List<FormatterStep> steps;
    private FormatExceptionPolicy exceptionPolicy;
    public static final File NO_FILE_SENTINEL = new File("NO_FILE_SENTINEL");

    private Formatter(String name, LineEnding.Policy lineEndingsPolicy, Charset encoding, Path rootDirectory, List<FormatterStep> steps, FormatExceptionPolicy exceptionPolicy) {
        this.name = name;
        this.lineEndingsPolicy = Objects.requireNonNull(lineEndingsPolicy, "lineEndingsPolicy");
        this.encoding = Objects.requireNonNull(encoding, "encoding");
        this.rootDir = Objects.requireNonNull(rootDirectory, "rootDir");
        this.steps = LibPreconditions.requireElementsNonNull(new ArrayList<FormatterStep>(steps));
        this.exceptionPolicy = Objects.requireNonNull(exceptionPolicy, "exceptionPolicy");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.lineEndingsPolicy);
        out.writeObject(this.encoding.name());
        out.writeObject(this.rootDir.toString());
        out.writeObject(this.steps);
        out.writeObject(this.exceptionPolicy);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.lineEndingsPolicy = (LineEnding.Policy)in.readObject();
        this.encoding = Charset.forName((String)in.readObject());
        this.rootDir = Paths.get((String)in.readObject(), new String[0]);
        this.steps = (List)in.readObject();
        this.exceptionPolicy = (FormatExceptionPolicy)in.readObject();
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public LineEnding.Policy getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public Path getRootDir() {
        return this.rootDir;
    }

    public List<FormatterStep> getSteps() {
        return this.steps;
    }

    public FormatExceptionPolicy getExceptionPolicy() {
        return this.exceptionPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isClean(File file) throws IOException {
        Objects.requireNonNull(file);
        String raw = new String(Files.readAllBytes(file.toPath()), this.encoding);
        String unix = LineEnding.toUnix(raw);
        int totalNewLines = (int)unix.codePoints().filter(val -> val == 10).count();
        int windowsNewLines = raw.length() - unix.length();
        if (this.lineEndingsPolicy.isUnix(file) ? windowsNewLines != 0 : windowsNewLines != totalNewLines) {
            return false;
        }
        String formatted = this.compute(unix, file);
        return formatted.equals(unix);
    }

    public void applyTo(File file) throws IOException {
        this.applyToAndReturnResultIfDirty(file);
    }

    @Nullable
    public String applyToAndReturnResultIfDirty(File file) throws IOException {
        Objects.requireNonNull(file);
        byte[] rawBytes = Files.readAllBytes(file.toPath());
        String raw = new String(rawBytes, this.encoding);
        String rawUnix = LineEnding.toUnix(raw);
        String formattedUnix = this.compute(rawUnix, file);
        String formatted = this.computeLineEndings(formattedUnix, file);
        byte[] formattedBytes = formatted.getBytes(this.encoding);
        if (!Arrays.equals(rawBytes, formattedBytes)) {
            Files.write(file.toPath(), formattedBytes, StandardOpenOption.TRUNCATE_EXISTING);
            return formattedUnix;
        }
        return null;
    }

    public String computeLineEndings(String unix, File file) {
        Objects.requireNonNull(unix, "unix");
        Objects.requireNonNull(file, "file");
        String ending = this.lineEndingsPolicy.getEndingFor(file);
        if (!ending.equals(LineEnding.UNIX.str())) {
            return unix.replace(LineEnding.UNIX.str(), ending);
        }
        return unix;
    }

    public String compute(String unix, File file) {
        Objects.requireNonNull(unix, "unix");
        Objects.requireNonNull(file, "file");
        for (FormatterStep step : this.steps) {
            try {
                String formatted = step.format(unix, file);
                if (formatted == null) continue;
                unix = LineEnding.toUnix(formatted);
            }
            catch (Throwable e) {
                if (file == NO_FILE_SENTINEL) {
                    this.exceptionPolicy.handleError(e, step, "");
                    continue;
                }
                String relativePath = this.rootDir.relativize(this.rootDir.getFileSystem().getPath(file.getPath(), new String[0])).toString();
                this.exceptionPolicy.handleError(e, step, relativePath);
            }
        }
        return unix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.encoding.hashCode();
        result = 31 * result + this.lineEndingsPolicy.hashCode();
        result = 31 * result + this.rootDir.hashCode();
        result = 31 * result + this.steps.hashCode();
        result = 31 * result + this.exceptionPolicy.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Formatter other = (Formatter)obj;
        return this.name.equals(other.name) && this.encoding.equals(other.encoding) && this.lineEndingsPolicy.equals(other.lineEndingsPolicy) && this.rootDir.equals(other.rootDir) && this.steps.equals(other.steps) && this.exceptionPolicy.equals(other.exceptionPolicy);
    }

    @Override
    public void close() {
        for (FormatterStep step : this.steps) {
            try {
                step.close();
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
        }
    }

    static void checkNotSentinel(File file) {
        if (file == NO_FILE_SENTINEL) {
            throw new IllegalArgumentException("This step requires the underlying file. If this is a test, use StepHarnessWithFile");
        }
    }

    public static class Builder {
        private String name = "unnamed";
        private LineEnding.Policy lineEndingsPolicy;
        private Charset encoding;
        private Path rootDir;
        private List<FormatterStep> steps;
        private FormatExceptionPolicy exceptionPolicy;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lineEndingsPolicy(LineEnding.Policy lineEndingsPolicy) {
            this.lineEndingsPolicy = lineEndingsPolicy;
            return this;
        }

        public Builder encoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder rootDir(Path rootDir) {
            this.rootDir = rootDir;
            return this;
        }

        public Builder steps(List<FormatterStep> steps) {
            this.steps = steps;
            return this;
        }

        public Builder exceptionPolicy(FormatExceptionPolicy exceptionPolicy) {
            this.exceptionPolicy = exceptionPolicy;
            return this;
        }

        public Formatter build() {
            return new Formatter(this.name, this.lineEndingsPolicy, this.encoding, this.rootDir, this.steps, this.exceptionPolicy == null ? FormatExceptionPolicy.failOnlyOnError() : this.exceptionPolicy);
        }
    }
}

