/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.java.ModuleHelper;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class GoogleJavaFormatStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_STYLE = "GOOGLE";
    private static final boolean DEFAULT_REFLOW_LONG_STRINGS = false;
    private static final boolean DEFAULT_REORDER_IMPORTS = false;
    private static final boolean DEFAULT_FORMAT_JAVADOC = true;
    private static final String NAME = "google-java-format";
    private static final String MAVEN_COORDINATE = "com.google.googlejavaformat:google-java-format";
    private final JarState.Promised jarState;
    private final String version;
    private final String style;
    private final boolean reflowLongStrings;
    private final boolean reorderImports;
    private final boolean formatJavadoc;
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support("google-java-format").addMin(11, "1.8").addMin(16, "1.10.0").addMin(21, "1.17.0").add(11, "1.23.0");

    private GoogleJavaFormatStep(JarState.Promised jarState, String version, String style, boolean reflowLongStrings, boolean reorderImports, boolean formatJavadoc) {
        this.jarState = jarState;
        this.version = version;
        this.style = style;
        this.reflowLongStrings = reflowLongStrings;
        this.reorderImports = reorderImports;
        this.formatJavadoc = formatJavadoc;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return GoogleJavaFormatStep.create(GoogleJavaFormatStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return GoogleJavaFormatStep.create(version, DEFAULT_STYLE, provisioner);
    }

    public static FormatterStep create(String version, String style, Provisioner provisioner) {
        return GoogleJavaFormatStep.create(version, style, provisioner, false);
    }

    public static FormatterStep create(String version, String style, Provisioner provisioner, boolean reflowLongStrings) {
        return GoogleJavaFormatStep.create(MAVEN_COORDINATE, version, style, provisioner, reflowLongStrings);
    }

    public static FormatterStep create(String groupArtifact, String version, String style, Provisioner provisioner, boolean reflowLongStrings) {
        return GoogleJavaFormatStep.create(groupArtifact, version, style, provisioner, reflowLongStrings, false);
    }

    public static FormatterStep create(String groupArtifact, String version, String style, Provisioner provisioner, boolean reflowLongStrings, boolean reorderImports) {
        return GoogleJavaFormatStep.create(groupArtifact, version, style, provisioner, reflowLongStrings, reorderImports, true);
    }

    public static FormatterStep create(String groupArtifact, String version, String style, Provisioner provisioner, boolean reflowLongStrings, boolean reorderImports, boolean formatJavadoc) {
        return GoogleJavaFormatStep.createInternally(groupArtifact, version, style, provisioner, reflowLongStrings, reorderImports, formatJavadoc, false);
    }

    static FormatterStep createRemoveUnusedImportsOnly(Provisioner provisioner) {
        return GoogleJavaFormatStep.createInternally(MAVEN_COORDINATE, GoogleJavaFormatStep.defaultVersion(), GoogleJavaFormatStep.defaultStyle(), provisioner, GoogleJavaFormatStep.defaultReflowLongStrings(), GoogleJavaFormatStep.defaultReorderImports(), GoogleJavaFormatStep.defaultFormatJavadoc(), true);
    }

    private static FormatterStep createInternally(String groupArtifact, String version, String style, Provisioner provisioner, boolean reflowLongStrings, boolean reorderImports, boolean formatJavadoc, boolean removeImports) {
        Objects.requireNonNull(groupArtifact, "groupArtifact");
        if (groupArtifact.chars().filter(ch -> ch == 58).count() != 1L) {
            throw new IllegalArgumentException("groupArtifact must be in the form 'groupId:artifactId'");
        }
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(style, "style");
        Objects.requireNonNull(provisioner, "provisioner");
        GoogleJavaFormatStep step = new GoogleJavaFormatStep(JarState.promise(() -> JarState.from(groupArtifact + ":" + version, provisioner)), version, style, reflowLongStrings, reorderImports, formatJavadoc);
        if (removeImports) {
            return FormatterStep.create(NAME, step, GoogleJavaFormatStep::equalityState, State::createRemoveUnusedImportsOnly);
        }
        return FormatterStep.create(NAME, step, GoogleJavaFormatStep::equalityState, State::createFormat);
    }

    public static String defaultGroupArtifact() {
        return MAVEN_COORDINATE;
    }

    public static String defaultVersion() {
        return Objects.requireNonNull(JVM_SUPPORT.getRecommendedFormatterVersion());
    }

    public static String defaultStyle() {
        return DEFAULT_STYLE;
    }

    public static boolean defaultReflowLongStrings() {
        return false;
    }

    public static boolean defaultReorderImports() {
        return false;
    }

    public static boolean defaultFormatJavadoc() {
        return true;
    }

    private State equalityState() {
        return new State(this.version, this.style, this.jarState.get(), this.reflowLongStrings, this.reorderImports, this.formatJavadoc);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JarState jarState;
        private final String version;
        private final String style;
        private final boolean reflowLongStrings;
        private final boolean reorderImports;
        private final boolean formatJavadoc;

        State(String version, String style, JarState jarState, boolean reflowLongStrings, boolean reorderImports, boolean formatJavadoc) {
            JVM_SUPPORT.assertFormatterSupported(version);
            ModuleHelper.doOpenInternalPackagesIfRequired();
            this.jarState = jarState;
            this.version = version;
            this.style = style;
            this.reflowLongStrings = reflowLongStrings;
            this.reorderImports = reorderImports;
            this.formatJavadoc = formatJavadoc;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.java.GoogleJavaFormatFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            FormatterFunc googleJavaFormatFormatterFunc = (FormatterFunc)constructor.newInstance(this.version, this.style, this.reflowLongStrings, this.reorderImports, this.formatJavadoc);
            return JVM_SUPPORT.suggestLaterVersionOnError(this.version, googleJavaFormatFormatterFunc);
        }

        FormatterFunc createRemoveUnusedImportsOnly() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.java.GoogleJavaFormatRemoveUnusedImporterFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class);
            FormatterFunc googleJavaFormatRemoveUnusedImporterFormatterFunc = (FormatterFunc)constructor.newInstance(this.version);
            return JVM_SUPPORT.suggestLaterVersionOnError(this.version, googleJavaFormatRemoveUnusedImporterFormatterFunc);
        }
    }
}

