/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.json.JacksonConfig;
import com.diffplug.spotless.json.JacksonJsonConfig;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class JacksonJsonStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAVEN_COORDINATE = "com.fasterxml.jackson.core:jackson-databind:";
    private static final String DEFAULT_VERSION = "2.17.2";
    public static final String NAME = "jacksonJson";
    private final JarState.Promised jarState;
    private final JacksonConfig jacksonConfig;

    private JacksonJsonStep(JarState.Promised jarState, JacksonConfig jacksonConfig) {
        this.jarState = jarState;
        this.jacksonConfig = jacksonConfig;
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static FormatterStep create(Provisioner provisioner) {
        return JacksonJsonStep.create(new JacksonJsonConfig(), JacksonJsonStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(JacksonJsonConfig jacksonConfig, String jacksonVersion, Provisioner provisioner) {
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.create(NAME, new JacksonJsonStep(JarState.promise(() -> JarState.from(MAVEN_COORDINATE + jacksonVersion, provisioner)), jacksonConfig), JacksonJsonStep::equalityState, State::toFormatter);
    }

    private State equalityState() {
        return new State(this.jarState.get(), this.jacksonConfig);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JacksonConfig jacksonConfig;
        private final JarState jarState;

        State(JarState jarState, JacksonConfig jacksonConfig) {
            this.jarState = jarState;
            this.jacksonConfig = jacksonConfig;
        }

        FormatterFunc toFormatter() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.json.JacksonJsonFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(JacksonJsonConfig.class);
            return (FormatterFunc)constructor.newInstance(this.jacksonConfig);
        }
    }
}

