/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.biome;

enum Architecture {
    ARM64,
    X64;


    public static Architecture guess() {
        String arch = System.getProperty("os.arch");
        String version = System.getProperty("os.version");
        if (arch == null || arch.isBlank()) {
            throw new IllegalStateException("No OS information is available, specify the Biome executable manually");
        }
        String msg = "Unsupported architecture " + arch + "/" + version + ", specify the path to the Biome executable manually";
        if (arch.equals("ppc64le")) {
            throw new IllegalStateException(msg);
        }
        if (arch.equals("s390x")) {
            throw new IllegalStateException(msg);
        }
        if (arch.equals("ppc64")) {
            throw new IllegalStateException(msg);
        }
        if (arch.equals("ppc")) {
            throw new IllegalStateException(msg);
        }
        if (arch.equals("aarch64")) {
            return ARM64;
        }
        if (arch.equals("arm")) {
            if (version.contains("v7")) {
                throw new IllegalStateException(msg);
            }
            return ARM64;
        }
        if (arch.contains("64")) {
            return X64;
        }
        throw new IllegalStateException(msg);
    }
}

