/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.gherkin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.gherkin.GherkinUtilsConfig;
import io.cucumber.gherkin.GherkinParser;
import io.cucumber.gherkin.utils.pretty.Pretty;
import io.cucumber.gherkin.utils.pretty.Syntax;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GherkinUtilsFormatterFunc
implements FormatterFunc {
    private static final Logger LOGGER = LoggerFactory.getLogger(GherkinUtilsFormatterFunc.class);
    private final GherkinUtilsConfig gherkinSimpleConfig;

    public GherkinUtilsFormatterFunc(GherkinUtilsConfig gherkinSimpleConfig) {
        this.gherkinSimpleConfig = gherkinSimpleConfig;
    }

    private GherkinDocument parse(String gherkin) {
        GherkinParser parser = GherkinParser.builder().includeSource(false).build();
        return (GherkinDocument)((Envelope)parser.parse(Envelope.of((Source)new Source("test.feature", gherkin, SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN))).findFirst().orElseThrow(() -> new IllegalArgumentException("No envelope"))).getGherkinDocument().orElseThrow(() -> new IllegalArgumentException("No gherkin document"));
    }

    @Override
    public String apply(String inputString) {
        GherkinDocument gherkinDocument = this.parse(inputString);
        return Pretty.prettyPrint((GherkinDocument)gherkinDocument, (Syntax)Syntax.gherkin);
    }
}

