/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SpotlessCache;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarState
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(JarState.class);
    @Nullable
    private static ClassLoader forcedClassLoader = null;
    private static final long serialVersionUID = 1L;
    private final FileSignature fileSignature;

    public static void setForcedClassLoader(@Nullable ClassLoader forcedClassLoader) {
        if (!Objects.equals(JarState.forcedClassLoader, forcedClassLoader)) {
            logger.info("Overriding the forced classloader for JarState from {} to {}", (Object)JarState.forcedClassLoader, (Object)forcedClassLoader);
        }
        JarState.forcedClassLoader = forcedClassLoader;
    }

    public static Promised promise(ThrowingEx.Supplier<JarState> supplier) {
        return new Promised(supplier);
    }

    private JarState(FileSignature fileSignature) {
        this.fileSignature = fileSignature;
    }

    public static JarState from(String mavenCoordinate, Provisioner provisioner) throws IOException {
        return JarState.from(Collections.singletonList(mavenCoordinate), provisioner);
    }

    public static JarState from(Collection<String> mavenCoordinates, Provisioner provisioner) throws IOException {
        return JarState.provisionWithTransitives(true, mavenCoordinates, provisioner);
    }

    public static JarState withoutTransitives(Collection<String> mavenCoordinates, Provisioner provisioner) throws IOException {
        return JarState.provisionWithTransitives(false, mavenCoordinates, provisioner);
    }

    private static JarState provisionWithTransitives(boolean withTransitives, Collection<String> mavenCoordinates, Provisioner provisioner) throws IOException {
        Objects.requireNonNull(mavenCoordinates, "mavenCoordinates");
        Objects.requireNonNull(provisioner, "provisioner");
        Set<File> jars = provisioner.provisionWithTransitives(withTransitives, mavenCoordinates);
        if (jars.isEmpty()) {
            throw new NoSuchElementException("Resolved to an empty result: " + mavenCoordinates.stream().collect(Collectors.joining(", ")));
        }
        FileSignature fileSignature = FileSignature.signAsSet(jars);
        return new JarState(fileSignature);
    }

    public static JarState preserveOrder(Collection<File> jars) throws IOException {
        FileSignature fileSignature = FileSignature.signAsList(jars);
        return new JarState(fileSignature);
    }

    URL[] jarUrls() {
        return (URL[])this.fileSignature.files().stream().map(File::toURI).map(ThrowingEx.wrap(URI::toURL)).toArray(URL[]::new);
    }

    public ClassLoader getClassLoader() {
        if (forcedClassLoader != null) {
            return forcedClassLoader;
        }
        return SpotlessCache.instance().classloader(this);
    }

    public ClassLoader getClassLoader(Serializable key) {
        if (forcedClassLoader != null) {
            return forcedClassLoader;
        }
        return SpotlessCache.instance().classloader(key, this);
    }

    public static class Promised
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final transient ThrowingEx.Supplier<JarState> supplier;
        private FileSignature.Promised cached;

        public Promised(ThrowingEx.Supplier<JarState> supplier) {
            this.supplier = supplier;
        }

        public JarState get() {
            try {
                if (this.cached == null) {
                    JarState result = this.supplier.get();
                    this.cached = result.fileSignature.asPromise();
                    return result;
                }
                return new JarState(this.cached.get());
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.get();
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }

        private void readObjectNoData() throws ObjectStreamException {
            throw new UnsupportedOperationException();
        }
    }
}

