/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.diktat;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Lint;
import com.diffplug.spotless.glue.diktat.compat.DiktatCompat1Dot2Dot5Adapter;
import com.diffplug.spotless.glue.diktat.compat.DiktatCompat2Dot0Dot0Adapter;
import com.diffplug.spotless.glue.diktat.compat.DiktatCompatAdapter;
import com.diffplug.spotless.glue.diktat.compat.DiktatReporting;
import java.io.File;
import java.util.stream.Collectors;

public class DiktatFormatterFunc
implements FormatterFunc.NeedsFile {
    private final DiktatCompatAdapter adapter;
    private final boolean isScript;

    public DiktatFormatterFunc(String version, File configFile, boolean isScript) {
        this.adapter = version.startsWith("1.") ? new DiktatCompat1Dot2Dot5Adapter(configFile) : new DiktatCompat2Dot0Dot0Adapter(configFile);
        this.isScript = isScript;
    }

    @Override
    public String applyWithFile(String unix, File file) {
        try {
            return this.adapter.format(file, unix, this.isScript);
        }
        catch (DiktatReporting.LintException e) {
            throw Lint.shortcut(e.lints.stream().map(lint -> Lint.atLine(lint.line, lint.ruleId, lint.detail)).collect(Collectors.toList()));
        }
    }
}

