/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LibPreconditions;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.ValuePerStep;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class PaddedCell {
    private final File file;
    private final Type type;
    private final List<String> steps;
    private static final int MAX_CYCLE = 10;

    private PaddedCell(File file, Type type, List<String> steps) {
        this.file = Objects.requireNonNull(file, "file");
        this.type = Objects.requireNonNull(type, "type");
        this.steps = new ArrayList<String>(steps);
        LibPreconditions.requireElementsNonNull(this.steps);
    }

    public File file() {
        return this.file;
    }

    public Type type() {
        return this.type;
    }

    public List<String> steps() {
        return Collections.unmodifiableList(this.steps);
    }

    public static PaddedCell check(Formatter formatter, File file) {
        Objects.requireNonNull(formatter, "formatter");
        Objects.requireNonNull(file, "file");
        byte[] rawBytes = ThrowingEx.get(() -> Files.readAllBytes(file.toPath()));
        String raw = new String(rawBytes, formatter.getEncoding());
        String original = LineEnding.toUnix(raw);
        return PaddedCell.check(formatter, file, original, 10, new ValuePerStep<Throwable>(formatter));
    }

    public static PaddedCell check(Formatter formatter, File file, String originalUnix) {
        return PaddedCell.check(formatter, file, originalUnix, new ValuePerStep<Throwable>(formatter));
    }

    public static PaddedCell check(Formatter formatter, File file, String originalUnix, ValuePerStep<Throwable> exceptionPerStep) {
        return PaddedCell.check(formatter, file, originalUnix, 10, exceptionPerStep);
    }

    private static PaddedCell check(Formatter formatter, File file, String original, int maxLength, ValuePerStep<Throwable> exceptionPerStep) {
        if (maxLength < 2) {
            throw new IllegalArgumentException("maxLength must be at least 2");
        }
        String appliedOnce = formatter.computeWithLint(original, file, exceptionPerStep);
        if (appliedOnce.equals(original)) {
            return Type.CONVERGE.create(file, Collections.singletonList(appliedOnce));
        }
        String appliedTwice = formatter.computeWithLint(appliedOnce, file, exceptionPerStep);
        if (appliedOnce.equals(appliedTwice)) {
            return Type.CONVERGE.create(file, Collections.singletonList(appliedOnce));
        }
        ArrayList<String> appliedN = new ArrayList<String>();
        appliedN.add(appliedOnce);
        appliedN.add(appliedTwice);
        String input = appliedTwice;
        while (appliedN.size() < maxLength) {
            String output = formatter.computeWithLint(input, file, exceptionPerStep);
            if (output.equals(input)) {
                return Type.CONVERGE.create(file, appliedN);
            }
            int idx = appliedN.indexOf(output);
            if (idx >= 0) {
                return Type.CYCLE.create(file, appliedN.subList(idx, appliedN.size()));
            }
            appliedN.add(output);
            input = output;
        }
        return Type.DIVERGE.create(file, appliedN);
    }

    public boolean misbehaved() {
        boolean isWellBehaved = this.type == Type.CONVERGE && this.steps.size() <= 1;
        return !isWellBehaved;
    }

    public boolean isResolvable() {
        return this.type != Type.DIVERGE;
    }

    public String canonical() {
        switch (this.type.ordinal()) {
            case 0: {
                return this.steps.get(this.steps.size() - 1);
            }
            case 1: {
                return Collections.min(this.steps, Comparator.comparing(String::length).thenComparing(Function.identity()));
            }
            case 2: {
                throw new IllegalArgumentException("No canonical form for a diverging result");
            }
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)this.type));
    }

    public String userMessage() {
        switch (this.type.ordinal()) {
            case 0: {
                return "converges after " + this.steps.size() + " steps";
            }
            case 1: {
                return "cycles between " + this.steps.size() + " steps";
            }
            case 2: {
                return "diverges after " + this.steps.size() + " steps";
            }
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf((Object)this.type));
    }

    public static enum Type {
        CONVERGE,
        CYCLE,
        DIVERGE;


        PaddedCell create(File file, List<String> steps) {
            return new PaddedCell(file, this, steps);
        }
    }
}

