/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Lint;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class Jvm {
    private static final int VERSION;

    public static int version() {
        return VERSION;
    }

    public static <V> Support<V> support(String formatterName) {
        Objects.requireNonNull(formatterName);
        return new Support(formatterName);
    }

    private Jvm() {
    }

    static {
        String jre = System.getProperty("java.version");
        if (jre.startsWith("1.8")) {
            VERSION = 8;
        } else {
            Matcher matcher = Pattern.compile("(\\d+)").matcher(jre);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Expected " + jre + " to start with an integer");
            }
            VERSION = Integer.parseInt(matcher.group(1));
            if (VERSION <= 8) {
                throw new IllegalArgumentException("Expected " + jre + " to start with an integer greater than 8");
            }
        }
    }

    public static final class Support<V> {
        static final String LINT_CODE = "jvm-version";
        private final String fmtName;
        private final Comparator<? super V> fmtVersionComparator;
        private final NavigableMap<Integer, V> jvm2fmtMaxVersion;
        private final NavigableMap<Integer, V> jvm2fmtMinVersion;
        private final NavigableMap<V, Integer> fmtMaxVersion2jvmVersion;

        private Support(String fromatterName) {
            this(fromatterName, new SemanticVersionComparator());
        }

        private Support(String formatterName, Comparator<? super V> formatterVersionComparator) {
            this.fmtName = formatterName;
            this.fmtVersionComparator = formatterVersionComparator;
            this.jvm2fmtMaxVersion = new TreeMap<Integer, V>();
            this.jvm2fmtMinVersion = new TreeMap<Integer, V>();
            this.fmtMaxVersion2jvmVersion = new TreeMap<Integer, Integer>(formatterVersionComparator);
        }

        public Support<V> add(int minimumJvmVersion, V maxFormatterVersion) {
            Objects.requireNonNull(maxFormatterVersion);
            if (this.jvm2fmtMaxVersion.put(minimumJvmVersion, maxFormatterVersion) != null) {
                throw new IllegalArgumentException("Added duplicate entry for JVM %d+.".formatted(minimumJvmVersion));
            }
            if (this.fmtMaxVersion2jvmVersion.put((Integer)maxFormatterVersion, minimumJvmVersion) != null) {
                throw new IllegalArgumentException("Added duplicate entry for formatter version %s.".formatted(maxFormatterVersion));
            }
            this.verifyVersionRangesDoNotIntersect(this.jvm2fmtMaxVersion, minimumJvmVersion, maxFormatterVersion);
            return this;
        }

        public Support<V> addMin(int minimumJvmVersion, V minFormatterVersion) {
            Objects.requireNonNull(minFormatterVersion);
            if (this.jvm2fmtMinVersion.put(minimumJvmVersion, minFormatterVersion) != null) {
                throw new IllegalArgumentException("Added duplicate entry for JVM %d+.".formatted(minimumJvmVersion));
            }
            this.verifyVersionRangesDoNotIntersect(this.jvm2fmtMinVersion, minimumJvmVersion, minFormatterVersion);
            return this;
        }

        private void verifyVersionRangesDoNotIntersect(NavigableMap<Integer, V> jvm2fmtVersion, int minimumJvmVersion, V formatterVersion) {
            Map.Entry<Integer, V> lower = jvm2fmtVersion.lowerEntry(minimumJvmVersion);
            if (lower != null && this.fmtVersionComparator.compare(formatterVersion, lower.getValue()) <= 0) {
                throw new IllegalArgumentException("%d/%s should be lower than %d/%s".formatted(minimumJvmVersion, formatterVersion, lower.getKey(), lower.getValue()));
            }
            Map.Entry<Integer, V> higher = jvm2fmtVersion.higherEntry(minimumJvmVersion);
            if (higher != null && this.fmtVersionComparator.compare(formatterVersion, higher.getValue()) >= 0) {
                throw new IllegalArgumentException("%d/%s should be higher than %d/%s".formatted(minimumJvmVersion, formatterVersion, higher.getKey(), higher.getValue()));
            }
        }

        @Nullable
        public V getRecommendedFormatterVersion() {
            Integer configuredJvmVersionOrNull = this.jvm2fmtMaxVersion.floorKey(Jvm.version());
            return configuredJvmVersionOrNull == null ? null : (V)this.jvm2fmtMaxVersion.get(configuredJvmVersionOrNull);
        }

        @Nullable
        public V getMinimumRequiredFormatterVersion() {
            Integer configuredJvmVersionOrNull = this.jvm2fmtMinVersion.floorKey(Jvm.version());
            return configuredJvmVersionOrNull == null ? null : (V)this.jvm2fmtMinVersion.get(configuredJvmVersionOrNull);
        }

        public void assertFormatterSupported(V formatterVersion) {
            Objects.requireNonNull(formatterVersion);
            String error = this.buildUnsupportedFormatterMessage(formatterVersion);
            if (!error.isEmpty()) {
                throw Lint.atUndefinedLine(LINT_CODE, error).shortcut();
            }
        }

        private String buildUnsupportedFormatterMessage(V fmtVersion) {
            int requiredJvmVersion = this.getRequiredJvmVersion(fmtVersion);
            if (Jvm.version() < requiredJvmVersion) {
                return this.buildUpgradeJvmMessage(fmtVersion) + "Upgrade your JVM or try " + this.toString();
            }
            V minimumFormatterVersion = this.getMinimumRequiredFormatterVersion();
            if (minimumFormatterVersion != null && this.fmtVersionComparator.compare(fmtVersion, minimumFormatterVersion) < 0) {
                return "You are running Spotless on JVM %d. This requires %s of at least %s (you are using %s).%n".formatted(Jvm.version(), this.fmtName, minimumFormatterVersion, fmtVersion);
            }
            return "";
        }

        private String buildUpgradeJvmMessage(V fmtVersion) {
            StringBuilder builder = new StringBuilder();
            builder.append("You are running Spotless on JVM %d".formatted(Jvm.version()));
            V recommendedFmtVersionOrNull = this.getRecommendedFormatterVersion();
            if (recommendedFmtVersionOrNull != null) {
                builder.append(", which limits you to %s %s.%n".formatted(this.fmtName, recommendedFmtVersionOrNull));
            } else {
                Map.Entry<V, Integer> nextFmtVersionOrNull = this.fmtMaxVersion2jvmVersion.ceilingEntry(fmtVersion);
                if (nextFmtVersionOrNull != null) {
                    builder.append(". %s %s requires JVM %d+".formatted(this.fmtName, fmtVersion, nextFmtVersionOrNull.getValue()));
                }
                builder.append(".%n".formatted(new Object[0]));
            }
            return builder.toString();
        }

        private int getRequiredJvmVersion(V fmtVersion) {
            Object maxKnownFmtVersion;
            Map.Entry<V, Integer> entry = this.fmtMaxVersion2jvmVersion.ceilingEntry(fmtVersion);
            if (entry == null) {
                entry = this.fmtMaxVersion2jvmVersion.lastEntry();
            }
            if (entry != null && this.fmtVersionComparator.compare(fmtVersion, maxKnownFmtVersion = this.jvm2fmtMaxVersion.get(entry.getValue())) <= 0) {
                return entry.getValue();
            }
            return 0;
        }

        public FormatterFunc suggestLaterVersionOnError(V formatterVersion, final FormatterFunc originalFunc) {
            Objects.requireNonNull(formatterVersion);
            Objects.requireNonNull(originalFunc);
            String hintUnsupportedProblem = this.buildUnsupportedFormatterMessage(formatterVersion);
            final String proposeDifferentFormatter = hintUnsupportedProblem.isEmpty() ? this.buildUpgradeFormatterMessage(formatterVersion) : hintUnsupportedProblem;
            return proposeDifferentFormatter.isEmpty() ? originalFunc : new FormatterFunc(){

                @Override
                public String apply(String unix, File file) throws Exception {
                    try {
                        return originalFunc.apply(unix, file);
                    }
                    catch (Exception e) {
                        throw new Exception(proposeDifferentFormatter, e);
                    }
                }

                @Override
                public String apply(String input) throws Exception {
                    try {
                        return originalFunc.apply(input);
                    }
                    catch (Exception e) {
                        throw new Exception(proposeDifferentFormatter, e);
                    }
                }
            };
        }

        private String buildUpgradeFormatterMessage(V fmtVersion) {
            StringBuilder builder = new StringBuilder();
            V minimumFormatterVersion = this.getMinimumRequiredFormatterVersion();
            V recommendedFmtVersionOrNull = this.getRecommendedFormatterVersion();
            if (minimumFormatterVersion != null && this.fmtVersionComparator.compare(fmtVersion, minimumFormatterVersion) < 0) {
                builder.append("You are running Spotless on JVM %d. This requires %s of at least %s.%n".formatted(Jvm.version(), this.fmtName, minimumFormatterVersion));
                builder.append("You are using %s %s.%n".formatted(this.fmtName, fmtVersion));
                if (recommendedFmtVersionOrNull != null) {
                    builder.append("%s %s is the recommended version, which may have fixed this problem.%n".formatted(this.fmtName, recommendedFmtVersionOrNull));
                }
            } else if (recommendedFmtVersionOrNull != null && this.fmtVersionComparator.compare(fmtVersion, recommendedFmtVersionOrNull) < 0) {
                builder.append("%s %s is currently being used, but outdated.%n".formatted(this.fmtName, fmtVersion));
                builder.append("%s %s is the recommended version, which may have fixed this problem.%n".formatted(this.fmtName, recommendedFmtVersionOrNull));
                builder.append("%s %s requires JVM %d+.".formatted(this.fmtName, recommendedFmtVersionOrNull, this.getRequiredJvmVersion(recommendedFmtVersionOrNull)));
            } else {
                V higherFormatterVersionOrNull = this.fmtMaxVersion2jvmVersion.higherKey(fmtVersion);
                if (higherFormatterVersionOrNull != null) {
                    builder.append(this.buildUpgradeJvmMessage(fmtVersion));
                    Integer higherJvmVersion = (Integer)this.fmtMaxVersion2jvmVersion.get(higherFormatterVersionOrNull);
                    builder.append("If you upgrade your JVM to %d+, then you can use %s %s, which may have fixed this problem.".formatted(higherJvmVersion, this.fmtName, higherFormatterVersionOrNull));
                }
            }
            return builder.toString();
        }

        public String toString() {
            return "%s alternatives:%n".formatted(this.fmtName) + this.jvm2fmtMaxVersion.entrySet().stream().map(e -> "- Version %s requires JVM %d+".formatted(e.getValue(), e.getKey())).collect(Collectors.joining(System.lineSeparator()));
        }

        @SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
        private static class SemanticVersionComparator<V>
        implements Comparator<V> {
            private SemanticVersionComparator() {
            }

            @Override
            public int compare(V version0, V version1) {
                Objects.requireNonNull(version0);
                Objects.requireNonNull(version1);
                int[] version0Items = SemanticVersionComparator.convert(version0);
                int[] version1Items = SemanticVersionComparator.convert(version1);
                int numberOfElements = version0Items.length > version1Items.length ? version0Items.length : version1Items.length;
                version0Items = Arrays.copyOf(version0Items, numberOfElements);
                version1Items = Arrays.copyOf(version1Items, numberOfElements);
                for (int i = 0; i < numberOfElements; ++i) {
                    if (version0Items[i] > version1Items[i]) {
                        return 1;
                    }
                    if (version1Items[i] <= version0Items[i]) continue;
                    return -1;
                }
                return 0;
            }

            private static <V> int[] convert(V versionObject) {
                try {
                    String versionString = versionObject.toString();
                    if (versionString.endsWith("-SNAPSHOT")) {
                        versionString = versionString.substring(0, versionString.length() - "-SNAPSHOT".length());
                    }
                    return Arrays.asList(versionString.split("\\.")).stream().mapToInt(Integer::parseInt).toArray();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Not a semantic version: %s".formatted(versionObject), e);
                }
            }
        }
    }
}

