/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.maven.AbstractSpotlessMojo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="apply", threadSafe=true)
public class SpotlessApplyMojo
extends AbstractSpotlessMojo {
    @Parameter(property="spotless.apply.skip", defaultValue="false")
    private boolean skip;

    @Override
    protected void process(List<File> files, Formatter formatter) throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Spotless apply skipped");
            return;
        }
        for (File file : files) {
            try {
                PaddedCell.DirtyState dirtyState = PaddedCell.calculateDirtyState((Formatter)formatter, (File)file);
                if (dirtyState.isClean() || dirtyState.didNotConverge()) continue;
                dirtyState.writeCanonicalTo(file);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to format file " + file, (Exception)e);
            }
        }
    }
}

