/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.common.base.Strings;
import java.io.File;
import java.util.Objects;
import java.util.UUID;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;

public class FileLocator {
    static final String TMP_RESOURCE_FILE_PREFIX = "spotless-resource-";
    private final ResourceManager resourceManager;
    private final File baseDir;
    private final File buildDir;

    public FileLocator(ResourceManager resourceManager, File baseDir, File buildDir) {
        this.resourceManager = Objects.requireNonNull(resourceManager);
        this.baseDir = Objects.requireNonNull(baseDir);
        this.buildDir = Objects.requireNonNull(buildDir);
    }

    public File locateFile(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return null;
        }
        File localFile = new File(path);
        if (localFile.exists() && localFile.isFile()) {
            return localFile;
        }
        String outputFile = FileLocator.tmpOutputFileName(path);
        try {
            return this.resourceManager.getResourceAsFile(path, outputFile);
        }
        catch (ResourceNotFoundException e) {
            throw new RuntimeException("Unable to locate file with path: " + path, e);
        }
        catch (FileResourceCreationException e) {
            throw new RuntimeException("Unable to create temporary file '" + outputFile + "' in the output directory", e);
        }
    }

    private static String tmpOutputFileName(String path) {
        String extension = FileUtils.extension((String)path);
        return TMP_RESOURCE_FILE_PREFIX + UUID.randomUUID() + '.' + extension;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getBuildDir() {
        return this.buildDir;
    }
}

