/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.incremental;

import com.diffplug.spotless.maven.incremental.PluginFingerprint;
import java.nio.file.Path;
import org.apache.maven.project.MavenProject;

class FileIndexConfig {
    private static final String INDEX_FILE_NAME = "spotless-index";
    private final MavenProject project;
    private final PluginFingerprint pluginFingerprint;

    FileIndexConfig(MavenProject project) {
        this(project, PluginFingerprint.empty());
    }

    FileIndexConfig(MavenProject project, PluginFingerprint pluginFingerprint) {
        this.project = project;
        this.pluginFingerprint = pluginFingerprint;
    }

    Path getProjectDir() {
        return this.project.getBasedir().toPath();
    }

    Path getIndexFile() {
        Path targetDir = this.getProjectDir().resolve(this.project.getBuild().getDirectory());
        return targetDir.resolve(INDEX_FILE_NAME);
    }

    PluginFingerprint getPluginFingerprint() {
        return this.pluginFingerprint;
    }
}

