/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.maven.AbstractSpotlessMojo;
import com.diffplug.spotless.maven.incremental.UpToDateChecker;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="apply", threadSafe=true)
public class SpotlessApplyMojo
extends AbstractSpotlessMojo {
    @Override
    protected void process(Iterable<File> files, Formatter formatter, UpToDateChecker upToDateChecker) throws MojoExecutionException {
        for (File file : files) {
            if (upToDateChecker.isUpToDate(file.toPath())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Spotless will not format an up-to-date file: " + file));
                continue;
            }
            try {
                PaddedCell.DirtyState dirtyState = PaddedCell.calculateDirtyState((Formatter)formatter, (File)file);
                if (!dirtyState.isClean() && !dirtyState.didNotConverge()) {
                    dirtyState.writeCanonicalTo(file);
                    this.buildContext.refresh(file);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to format file " + file, (Exception)e);
            }
            upToDateChecker.setUpToDate(file.toPath());
        }
    }
}

