/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import com.diffplug.spotless.maven.AbstractSpotlessMojo;
import com.diffplug.spotless.maven.ImpactedFilesTracker;
import com.diffplug.spotless.maven.incremental.UpToDateChecker;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="apply", threadSafe=true)
public class SpotlessApplyMojo
extends AbstractSpotlessMojo {
    @Override
    protected void process(Iterable<File> files, Formatter formatter, UpToDateChecker upToDateChecker) throws MojoExecutionException {
        ImpactedFilesTracker counter = new ImpactedFilesTracker();
        for (File file : files) {
            if (upToDateChecker.isUpToDate(file.toPath())) {
                counter.skippedAsCleanCache();
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Spotless will not format an up-to-date file: " + file));
                continue;
            }
            try {
                PaddedCell.DirtyState dirtyState = PaddedCell.calculateDirtyState((Formatter)formatter, (File)file);
                if (!dirtyState.isClean() && !dirtyState.didNotConverge()) {
                    this.getLog().info((CharSequence)String.format("Writing clean file: %s", file));
                    dirtyState.writeCanonicalTo(file);
                    this.buildContext.refresh(file);
                    counter.cleaned();
                } else {
                    counter.checkedButAlreadyClean();
                }
            }
            catch (IOException | RuntimeException e) {
                throw new MojoExecutionException("Unable to format file " + file, e);
            }
            upToDateChecker.setUpToDate(file.toPath());
        }
        if (counter.getTotal() > 0) {
            this.getLog().info((CharSequence)String.format("Spotless.%s is keeping %s files clean - %s were changed to be clean, %s were already clean, %s were skipped because caching determined they were already clean", formatter.getName(), counter.getTotal(), counter.getCleaned(), counter.getCheckedButAlreadyClean(), counter.getSkippedAsCleanCache()));
        } else {
            this.getLog().debug((CharSequence)String.format("Spotless.%s has no target files. Examine your `<includes>`: https://github.com/diffplug/spotless/tree/main/plugin-maven#quickstart", formatter.getName()));
        }
    }
}

