/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.maven.FormatterConfig;
import com.diffplug.spotless.maven.FormatterFactory;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

class FormattersHolder
implements AutoCloseable {
    final Map<FormatterFactory, Formatter> openFormatters;
    final Map<FormatterFactory, Supplier<Iterable<File>>> factoryToFiles;

    FormattersHolder(Map<FormatterFactory, Formatter> openFormatters, Map<FormatterFactory, Supplier<Iterable<File>>> factoryToFiles) {
        this.openFormatters = openFormatters;
        this.factoryToFiles = factoryToFiles;
    }

    public String nameFor(FormatterFactory factory) {
        return factory.getClass().getSimpleName();
    }

    static FormattersHolder create(Map<FormatterFactory, Supplier<Iterable<File>>> formatterFactoryToFiles, FormatterConfig config) {
        LinkedHashMap<FormatterFactory, Formatter> openFormatters = new LinkedHashMap<FormatterFactory, Formatter>();
        try {
            for (Map.Entry<FormatterFactory, Supplier<Iterable<File>>> entry : formatterFactoryToFiles.entrySet()) {
                FormatterFactory formatterFactory = entry.getKey();
                Supplier<Iterable<File>> files = entry.getValue();
                Formatter formatter = formatterFactory.newFormatter(files, config);
                openFormatters.put(formatterFactory, formatter);
            }
        }
        catch (RuntimeException openError) {
            try {
                FormattersHolder.close(openFormatters.values());
            }
            catch (Exception closeError) {
                openError.addSuppressed(closeError);
            }
            throw openError;
        }
        return new FormattersHolder(openFormatters, formatterFactoryToFiles);
    }

    @Override
    public void close() {
        try {
            FormattersHolder.close(this.openFormatters.values());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to close formatters", e);
        }
    }

    private static void close(Collection<Formatter> formatters) throws Exception {
        Exception error = null;
        for (Formatter formatter : formatters) {
            try {
                formatter.close();
            }
            catch (Exception e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

