/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.DirtyState;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.extra.integration.DiffMessageFormatter;
import com.diffplug.spotless.maven.AbstractSpotlessMojo;
import com.diffplug.spotless.maven.ImpactedFilesTracker;
import com.diffplug.spotless.maven.incremental.UpToDateChecker;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SpotlessCheckMojo
extends AbstractSpotlessMojo {
    private static final String INCREMENTAL_MESSAGE_PREFIX = "Spotless Violation: ";
    @Parameter(defaultValue="WARNING")
    private MessageSeverity m2eIncrementalBuildMessageSeverity;

    @Override
    protected void process(String name, Iterable<File> files, Formatter formatter, UpToDateChecker upToDateChecker) throws MojoExecutionException {
        ImpactedFilesTracker counter = new ImpactedFilesTracker();
        ArrayList<File> problemFiles = new ArrayList<File>();
        for (File file : files) {
            if (upToDateChecker.isUpToDate(file.toPath())) {
                counter.skippedAsCleanCache();
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Spotless will not check an up-to-date file: " + file));
                continue;
            }
            this.buildContext.removeMessages(file);
            try {
                DirtyState dirtyState = DirtyState.of((Formatter)formatter, (File)file);
                if (!dirtyState.isClean() && !dirtyState.didNotConverge()) {
                    problemFiles.add(file);
                    if (this.buildContext.isIncremental()) {
                        Map.Entry diffEntry = DiffMessageFormatter.diff((Path)this.baseDir.toPath(), (Formatter)formatter, (File)file);
                        this.buildContext.addMessage(file, (Integer)diffEntry.getKey() + 1, 0, INCREMENTAL_MESSAGE_PREFIX + (String)diffEntry.getValue(), this.m2eIncrementalBuildMessageSeverity.getSeverity(), null);
                    }
                    counter.cleaned();
                    continue;
                }
                counter.checkedButAlreadyClean();
                upToDateChecker.setUpToDate(file.toPath());
            }
            catch (IOException | RuntimeException e) {
                throw new MojoExecutionException("Unable to check file " + file, e);
            }
        }
        if (counter.getTotal() > 0) {
            this.getLog().info((CharSequence)String.format("Spotless.%s is keeping %s files clean - %s needs changes to be clean, %s were already clean, %s were skipped because caching determined they were already clean", name, counter.getTotal(), counter.getCleaned(), counter.getCheckedButAlreadyClean(), counter.getSkippedAsCleanCache()));
        } else {
            this.getLog().debug((CharSequence)String.format("Spotless.%s has no target files. Examine your `<includes>`: https://github.com/diffplug/spotless/tree/main/plugin-maven#quickstart", name));
        }
        if (!problemFiles.isEmpty()) {
            throw new MojoExecutionException(DiffMessageFormatter.builder().runToFix("Run 'mvn spotless:apply' to fix these violations.").formatter(this.baseDir.toPath(), formatter).problemFiles(problemFiles).getMessage());
        }
    }

    public static enum MessageSeverity {
        WARNING(1),
        ERROR(2);

        private final int severity;

        private MessageSeverity(int severity) {
            this.severity = severity;
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

