/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.extra.GitRatchet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

final class GitRatchetMaven
extends GitRatchet<File> {
    private static volatile GitRatchetMaven instance = new GitRatchetMaven();

    private GitRatchetMaven() {
    }

    protected File getDir(File project) {
        return project;
    }

    protected File getParent(File project) {
        return project.getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GitRatchetMaven instance() {
        if (instance != null) return instance;
        Class<GitRatchetMaven> clazz = GitRatchetMaven.class;
        synchronized (GitRatchetMaven.class) {
            if (instance != null) return instance;
            instance = new GitRatchetMaven();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    Iterable<String> getDirtyFiles(File baseDir, String ratchetFrom) throws IOException {
        Repository repository = this.repositoryFor(baseDir);
        ObjectId sha = this.rootTreeShaOf(baseDir, ratchetFrom);
        IndexDiff indexDiff = new IndexDiff(repository, sha, (WorkingTreeIterator)new FileTreeIterator(repository));
        indexDiff.diff();
        String workTreePath = repository.getWorkTree().getPath();
        Path baseDirPath = Path.of(baseDir.getPath(), new String[0]);
        HashSet<String> dirtyPaths = new HashSet<String>(indexDiff.getChanged());
        dirtyPaths.addAll(indexDiff.getAdded());
        dirtyPaths.addAll(indexDiff.getConflicting());
        dirtyPaths.addAll(indexDiff.getUntracked());
        for (String path2 : indexDiff.getModified()) {
            if (dirtyPaths.add(path2) || !this.isClean(baseDir, sha, path2)) continue;
            dirtyPaths.remove(path2);
        }
        for (String path2 : indexDiff.getRemoved()) {
            if (!dirtyPaths.contains(path2) || !this.isClean(baseDir, sha, path2)) continue;
            dirtyPaths.remove(path2);
        }
        dirtyPaths.removeAll(indexDiff.getMissing());
        return dirtyPaths.stream().map(path -> baseDirPath.relativize(Path.of(workTreePath, path)).toString()).collect(Collectors.toList());
    }
}

