/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.npm.TsConfigFileType;
import com.diffplug.spotless.npm.TsFmtFormatterStep;
import com.diffplug.spotless.npm.TypedTsFmtConfigFile;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public class TypescriptExtension
extends FormatExtension {
    static final String NAME = "typescript";

    public TypescriptExtension(SpotlessExtension root) {
        super(root);
    }

    public TypescriptFormatExtension tsfmt() {
        TypescriptFormatExtension tsfmt = new TypescriptFormatExtension();
        this.addStep(tsfmt.createStep());
        return tsfmt;
    }

    @Override
    public FormatExtension.PrettierConfig prettier() {
        TypescriptPrettierConfig prettierConfig = new TypescriptPrettierConfig();
        this.addStep(((FormatExtension.PrettierConfig)prettierConfig).createStep());
        return prettierConfig;
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget("**/*.ts");
        }
        super.setupTask(task);
    }

    public class TypescriptPrettierConfig
    extends FormatExtension.PrettierConfig {
        @Override
        FormatterStep createStep() {
            this.fixParserToTypescript();
            return super.createStep();
        }

        private void fixParserToTypescript() {
            if (this.prettierConfig == null) {
                this.prettierConfig = Collections.singletonMap("parser", TypescriptExtension.NAME);
            } else {
                String replaced = this.prettierConfig.put("parser", TypescriptExtension.NAME);
                if (replaced != null) {
                    TypescriptExtension.this.getProject().getLogger().warn("overriding parser option to 'typescript'. Was set to '{}'", (Object)replaced);
                }
            }
        }
    }

    public class TypescriptFormatExtension
    extends FormatExtension.NpmStepConfig<TypescriptFormatExtension> {
        private Map<String, Object> config = Collections.emptyMap();
        @Nullable
        TsConfigFileType configFileType = null;
        @Nullable
        Object configFilePath = null;

        public void config(Map<String, Object> config) {
            this.config = new TreeMap<String, Object>(Objects.requireNonNull(config));
            TypescriptExtension.this.replaceStep(this.createStep());
        }

        public void tsconfigFile(Object path) {
            this.configFile(TsConfigFileType.TSCONFIG, path);
        }

        public void tslintFile(Object path) {
            this.configFile(TsConfigFileType.TSLINT, path);
        }

        public void vscodeFile(Object path) {
            this.configFile(TsConfigFileType.VSCODE, path);
        }

        public void tsfmtFile(Object path) {
            this.configFile(TsConfigFileType.TSFMT, path);
        }

        private void configFile(TsConfigFileType filetype, Object path) {
            this.configFileType = Objects.requireNonNull(filetype);
            this.configFilePath = Objects.requireNonNull(path);
            TypescriptExtension.this.replaceStep(this.createStep());
        }

        @Override
        public FormatterStep createStep() {
            Project project = TypescriptExtension.this.getProject();
            return TsFmtFormatterStep.create((Provisioner)GradleProvisioner.fromProject(project), (File)project.getBuildDir(), (File)this.npmFileOrNull(), (File)project.getProjectDir(), (TypedTsFmtConfigFile)this.typedConfigFile(), this.config);
        }

        private TypedTsFmtConfigFile typedConfigFile() {
            if (this.configFileType != null && this.configFilePath != null) {
                return new TypedTsFmtConfigFile(this.configFileType, TypescriptExtension.this.getProject().file(this.configFilePath));
            }
            return null;
        }
    }
}

