/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyStrict;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.PaddedCell;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

@CacheableTask
public class SpotlessTask
extends DefaultTask {
    protected String encoding = "UTF-8";
    protected LineEnding.Policy lineEndingsPolicy = LineEnding.UNIX.createPolicy();
    protected String filePatterns = "";
    protected FormatExceptionPolicy exceptionPolicy = new FormatExceptionPolicyStrict();
    protected FileCollection target;
    private File outputDirectory = new File(this.getProject().getBuildDir(), "spotless/" + this.getName());
    protected List<FormatterStep> steps = new ArrayList<FormatterStep>();

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = Objects.requireNonNull(encoding);
    }

    @Input
    public LineEnding.Policy getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    public void setLineEndingsPolicy(LineEnding.Policy lineEndingsPolicy) {
        this.lineEndingsPolicy = Objects.requireNonNull(lineEndingsPolicy);
    }

    @Deprecated
    @Internal
    public boolean isPaddedCell() {
        return true;
    }

    @Deprecated
    public void setPaddedCell(boolean paddedCell) {
        this.getLogger().warn("PaddedCell is now always on, and cannot be turned off.");
    }

    @Input
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = Objects.requireNonNull(filePatterns);
    }

    public void setExceptionPolicy(FormatExceptionPolicy exceptionPolicy) {
        this.exceptionPolicy = Objects.requireNonNull(exceptionPolicy);
    }

    @Input
    public FormatExceptionPolicy getExceptionPolicy() {
        return this.exceptionPolicy;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getTarget() {
        return this.target;
    }

    public void setTarget(Iterable<File> target) {
        this.target = target instanceof FileCollection ? (FileCollection)target : this.getProject().files(new Object[]{target});
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public List<FormatterStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public void setSteps(List<FormatterStep> steps) {
        this.steps = PluginGradlePreconditions.requireElementsNonNull(steps);
    }

    public boolean addStep(FormatterStep step) {
        return this.steps.add(Objects.requireNonNull(step));
    }

    String formatName() {
        String name = this.getName();
        if (name.startsWith("spotless")) {
            return name.substring("spotless".length()).toLowerCase(Locale.ROOT);
        }
        return name;
    }

    @TaskAction
    public void performAction(IncrementalTaskInputs inputs) throws Exception {
        Predicate<File> shouldInclude;
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> target'");
        }
        if (!inputs.isIncremental()) {
            this.getLogger().info("Not incremental: removing prior outputs");
            this.getProject().delete(new Object[]{this.outputDirectory});
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        if (this.filePatterns.isEmpty()) {
            shouldInclude = file -> true;
        } else {
            String[] includePatterns = this.filePatterns.split(",");
            List compiledIncludePatterns = Arrays.stream(includePatterns).map(Pattern::compile).collect(Collectors.toList());
            shouldInclude = file -> compiledIncludePatterns.stream().anyMatch(filePattern -> filePattern.matcher(file.getAbsolutePath()).matches());
        }
        try (Formatter formatter = this.buildFormatter();){
            inputs.outOfDate(inputDetails -> {
                File input = inputDetails.getFile();
                if (shouldInclude.test(input) && input.isFile()) {
                    try {
                        this.processInputFile(formatter, input);
                    }
                    catch (IOException e) {
                        throw Errors.asRuntime((Throwable)e);
                    }
                }
            });
        }
        inputs.removed(removedDetails -> {
            File input = removedDetails.getFile();
            if (shouldInclude.test(input)) {
                try {
                    this.deletePreviousResult(input);
                }
                catch (IOException e) {
                    throw Errors.asRuntime((Throwable)e);
                }
            }
        });
    }

    private void processInputFile(Formatter formatter, File input) throws IOException {
        File output = this.getOutputFile(input);
        this.getLogger().debug("Applying format to " + input + " and writing to " + output);
        PaddedCell.DirtyState dirtyState = PaddedCell.calculateDirtyState((Formatter)formatter, (File)input);
        if (dirtyState.isClean()) {
            Files.deleteIfExists(output.toPath());
        } else if (dirtyState.didNotConverge()) {
            this.getLogger().warn("Skipping '" + input + "' because it does not converge.  Run `spotlessDiagnose` to understand why");
        } else {
            Path parentDir = output.toPath().getParent();
            if (parentDir == null) {
                throw new IllegalStateException("Every file has a parent folder.");
            }
            Files.createDirectories(parentDir, new FileAttribute[0]);
            dirtyState.writeCanonicalTo(output);
        }
    }

    private void deletePreviousResult(File input) throws IOException {
        File output = this.getOutputFile(input);
        Files.deleteIfExists(output.toPath());
    }

    private File getOutputFile(File input) {
        String outputFileName = FormatExtension.relativize(this.getProject().getProjectDir(), input);
        if (outputFileName == null) {
            outputFileName = input.getAbsolutePath();
        }
        return new File(this.outputDirectory, outputFileName);
    }

    Formatter buildFormatter() {
        return Formatter.builder().lineEndingsPolicy(this.lineEndingsPolicy).encoding(Charset.forName(this.encoding)).rootDir(this.getProject().getRootDir().toPath()).steps(this.steps).exceptionPolicy(this.exceptionPolicy).build();
    }
}

