/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.gradle.spotless.CppExtension;
import com.diffplug.gradle.spotless.CssExtension;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.FreshMarkExtension;
import com.diffplug.gradle.spotless.GroovyExtension;
import com.diffplug.gradle.spotless.GroovyGradleExtension;
import com.diffplug.gradle.spotless.IdeHook;
import com.diffplug.gradle.spotless.JavaExtension;
import com.diffplug.gradle.spotless.KotlinExtension;
import com.diffplug.gradle.spotless.KotlinGradleExtension;
import com.diffplug.gradle.spotless.RegisterDependenciesTask;
import com.diffplug.gradle.spotless.ScalaExtension;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessCheck;
import com.diffplug.gradle.spotless.SpotlessDiagnoseTask;
import com.diffplug.gradle.spotless.SpotlessPlugin;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SqlExtension;
import com.diffplug.gradle.spotless.TypescriptExtension;
import com.diffplug.gradle.spotless.XmlExtension;
import com.diffplug.spotless.LineEnding;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class SpotlessExtension {
    final Project project;
    final Task rootCheckTask;
    final Task rootApplyTask;
    final Task rootDiagnoseTask;
    final RegisterDependenciesTask registerDependenciesTask;
    static final String EXTENSION = "spotless";
    static final String CHECK = "Check";
    static final String APPLY = "Apply";
    static final String DIAGNOSE = "Diagnose";
    private static final String TASK_GROUP = "Verification";
    private static final String CHECK_DESCRIPTION = "Checks that sourcecode satisfies formatting steps.";
    private static final String APPLY_DESCRIPTION = "Applies code formatting steps to sourcecode in-place.";
    private static final String FILES_PROPERTY = "spotlessFiles";
    LineEnding lineEndings = LineEnding.GIT_ATTRIBUTES;
    Charset encoding = StandardCharsets.UTF_8;
    final Map<String, FormatExtension> formats = new LinkedHashMap<String, FormatExtension>();
    boolean enforceCheck = true;

    public SpotlessExtension(Project project) {
        this.project = Objects.requireNonNull(project);
        this.rootCheckTask = project.task("spotlessCheck");
        this.rootCheckTask.setGroup(TASK_GROUP);
        this.rootCheckTask.setDescription(CHECK_DESCRIPTION);
        this.rootApplyTask = project.task("spotlessApply");
        this.rootApplyTask.setGroup(TASK_GROUP);
        this.rootApplyTask.setDescription(APPLY_DESCRIPTION);
        this.rootDiagnoseTask = project.task("spotlessDiagnose");
        this.rootDiagnoseTask.setGroup(TASK_GROUP);
        RegisterDependenciesTask registerDependenciesTask = (RegisterDependenciesTask)((Object)project.getRootProject().getTasks().findByName("spotlessInternalRegisterDependencies"));
        if (registerDependenciesTask == null) {
            registerDependenciesTask = (RegisterDependenciesTask)project.getRootProject().getTasks().create("spotlessInternalRegisterDependencies", RegisterDependenciesTask.class);
            registerDependenciesTask.setup();
        }
        this.registerDependenciesTask = registerDependenciesTask;
    }

    public LineEnding getLineEndings() {
        return this.lineEndings;
    }

    public void setLineEndings(LineEnding lineEndings) {
        this.lineEndings = Objects.requireNonNull(lineEndings);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String name) {
        Objects.requireNonNull(name);
        this.setEncoding(Charset.forName(name));
    }

    public void setEncoding(Charset charset) {
        this.encoding = Objects.requireNonNull(charset);
    }

    public void encoding(String charset) {
        this.setEncoding(charset);
    }

    public void java(Action<JavaExtension> closure) {
        Objects.requireNonNull(closure);
        this.configure("java", JavaExtension.class, closure);
    }

    public void scala(Action<ScalaExtension> closure) {
        Objects.requireNonNull(closure);
        this.configure("scala", ScalaExtension.class, closure);
    }

    public void kotlin(Action<KotlinExtension> closure) {
        Objects.requireNonNull(closure);
        this.configure("kotlin", KotlinExtension.class, closure);
    }

    public void kotlinGradle(Action<KotlinGradleExtension> closure) {
        Objects.requireNonNull(closure);
        this.configure("kotlinGradle", KotlinGradleExtension.class, closure);
    }

    public void freshmark(Action<FreshMarkExtension> closure) {
        Objects.requireNonNull(closure);
        this.configure("freshmark", FreshMarkExtension.class, closure);
    }

    public void groovy(Action<GroovyExtension> closure) {
        this.configure("groovy", GroovyExtension.class, closure);
    }

    public void groovyGradle(Action<GroovyGradleExtension> closure) {
        this.configure("groovyGradle", GroovyGradleExtension.class, closure);
    }

    public void sql(Action<SqlExtension> closure) {
        this.configure("sql", SqlExtension.class, closure);
    }

    @Deprecated
    public void css(Action<CssExtension> closure) {
        this.configure("css", CssExtension.class, closure);
    }

    @Deprecated
    public void xml(Action<XmlExtension> closure) {
        this.configure("xml", XmlExtension.class, closure);
    }

    public void cpp(Action<CppExtension> closure) {
        this.configure("cpp", CppExtension.class, closure);
    }

    public void typescript(Action<TypescriptExtension> closure) {
        this.configure("typescript", TypescriptExtension.class, closure);
    }

    public void format(String name, Action<FormatExtension> closure) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(closure, "closure");
        this.configure(name, FormatExtension.class, closure);
    }

    public void removeFormat(String name) {
        Objects.requireNonNull(name);
        FormatExtension toRemove = this.formats.remove(name);
        if (toRemove == null) {
            this.project.getLogger().warn("Called removeFormat('" + name + "') but there was no such format.");
        }
    }

    public boolean isEnforceCheck() {
        return this.enforceCheck;
    }

    public void setEnforceCheck(boolean enforceCheck) {
        this.enforceCheck = enforceCheck;
    }

    private <T extends FormatExtension> void configure(String name, Class<T> clazz, Action<T> configure) {
        T value = this.maybeCreate(name, clazz);
        configure.execute(value);
    }

    private <T extends FormatExtension> T maybeCreate(String name, Class<T> clazz) {
        FormatExtension existing = this.formats.get(name);
        if (existing != null) {
            if (!existing.getClass().equals(clazz)) {
                throw new GradleException("Tried to add format named '" + name + "' of type " + clazz + " but one has already been created of type " + existing.getClass());
            }
            return (T)existing;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(SpotlessExtension.class);
            FormatExtension formatExtension = (FormatExtension)constructor.newInstance(this);
            this.formats.put(name, formatExtension);
            this.createFormatTasks(name, formatExtension);
            return (T)formatExtension;
        }
        catch (NoSuchMethodException e) {
            throw new GradleException("Must have a constructor " + clazz.getSimpleName() + "(SpotlessExtension root)", (Throwable)e);
        }
        catch (Exception e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }

    private void createFormatTasks(String name, FormatExtension formatExtension) {
        String taskName = EXTENSION + SpotlessPlugin.capitalize(name);
        SpotlessTask spotlessTask = (SpotlessTask)this.project.getTasks().create(taskName, SpotlessTask.class);
        this.project.afterEvaluate(unused -> formatExtension.setupTask(spotlessTask));
        Task clean = this.project.getTasks().getByName("clean");
        spotlessTask.mustRunAfter(new Object[]{clean});
        SpotlessCheck checkTask = (SpotlessCheck)this.project.getTasks().create(taskName + CHECK, SpotlessCheck.class);
        checkTask.setSpotlessOutDirectory(spotlessTask.getOutputDirectory());
        checkTask.source = spotlessTask;
        checkTask.dependsOn(new Object[]{spotlessTask});
        SpotlessApply applyTask = (SpotlessApply)this.project.getTasks().create(taskName + APPLY, SpotlessApply.class);
        applyTask.setSpotlessOutDirectory(spotlessTask.getOutputDirectory());
        applyTask.source = spotlessTask;
        applyTask.dependsOn(new Object[]{spotlessTask});
        this.project.afterEvaluate(unused -> {
            String filePatterns = this.project.hasProperty(FILES_PROPERTY) && this.project.property(FILES_PROPERTY) instanceof String ? (String)this.project.property(FILES_PROPERTY) : "";
            spotlessTask.setFilePatterns(filePatterns);
        });
        this.rootCheckTask.dependsOn(new Object[]{checkTask});
        this.rootApplyTask.dependsOn(new Object[]{applyTask});
        SpotlessDiagnoseTask diagnoseTask = (SpotlessDiagnoseTask)this.project.getTasks().create(taskName + DIAGNOSE, SpotlessDiagnoseTask.class);
        diagnoseTask.source = spotlessTask;
        this.rootDiagnoseTask.dependsOn(new Object[]{diagnoseTask});
        diagnoseTask.mustRunAfter(new Object[]{clean});
        if (this.project.hasProperty("spotlessIdeHook")) {
            spotlessTask.setEnabled(false);
            checkTask.setEnabled(false);
            applyTask.setEnabled(false);
            this.rootApplyTask.doLast(unused -> IdeHook.performHook(spotlessTask));
        }
    }
}

