/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import com.diffplug.spotless.extra.groovy.GrEclipseFormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import com.diffplug.spotless.java.ImportOrderStep;
import java.util.List;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.SourceSet;

public class GroovyExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense {
    static final String NAME = "groovy";
    boolean excludeJava = false;

    public GroovyExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public void excludeJava() {
        this.excludeJava(true);
    }

    public void excludeJava(boolean excludeJava) {
        this.excludeJava = excludeJava;
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, "package ");
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, "package ");
    }

    @Deprecated
    public void importOrder(List<String> importOrder) {
        this.getProject().getLogger().warn(StringPrinter.buildStringFromLines((String[])new String[]{"'importOrder([x, y, z])' is deprecated.", "Use 'importOrder x, y, z' instead.", "For details see https://github.com/diffplug/spotless/tree/master/plugin-gradle#applying-to-java-source"}));
        this.importOrder(importOrder.toArray(new String[0]));
    }

    public void importOrder(String ... importOrder) {
        this.addStep(ImportOrderStep.forGroovy().createFrom(importOrder));
    }

    public void importOrderFile(Object importOrderFile) {
        Objects.requireNonNull(importOrderFile);
        this.addStep(ImportOrderStep.forGroovy().createFrom(this.getProject().file(importOrderFile)));
    }

    public GrEclipseConfig greclipse() {
        return this.greclipse(GrEclipseFormatterStep.defaultVersion());
    }

    public GrEclipseConfig greclipse(String version) {
        return new GrEclipseConfig(version, this);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            JavaPluginConvention convention = (JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class);
            if (convention == null || !this.getProject().getPlugins().hasPlugin(GroovyBasePlugin.class)) {
                throw new GradleException("You must apply the groovy plugin before the spotless plugin if you are using the groovy extension.");
            }
            ConfigurableFileCollection union = this.getProject().files(new Object[0]);
            for (SourceSet sourceSet : convention.getSourceSets()) {
                GroovySourceSet groovySourceSet = (GroovySourceSet)new DslObject((Object)sourceSet).getConvention().getPlugin(GroovySourceSet.class);
                if (this.excludeJava) {
                    union = union.plus((FileCollection)groovySourceSet.getAllGroovy());
                    continue;
                }
                union = union.plus((FileCollection)groovySourceSet.getGroovy());
            }
            this.target = union;
        } else if (this.excludeJava) {
            throw new IllegalArgumentException("'excludeJava' is not supported in combination with a custom 'target'.");
        }
        this.steps.replaceAll(step -> {
            if (LicenseHeaderStep.name().equals(step.getName())) {
                return step.filterByFile(LicenseHeaderStep.unsupportedJvmFilesFilter());
            }
            return step;
        });
        super.setupTask(task);
    }

    public static class GrEclipseConfig {
        private final EclipseBasedStepBuilder builder;
        private final FormatExtension extension;

        GrEclipseConfig(String version, FormatExtension extension) {
            this.extension = extension;
            this.builder = GrEclipseFormatterStep.createBuilder((Provisioner)extension.provisioner());
            this.builder.setVersion(version);
            extension.addStep(this.builder.build());
        }

        public void configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = this.extension.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            this.extension.replaceStep(this.builder.build());
        }
    }
}

