/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.extra.integration.DiffMessageFormatter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public class SpotlessCheck
extends DefaultTask {
    SpotlessTask source;
    private File spotlessOutDirectory;

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputDirectory
    public File getSpotlessOutDirectory() {
        return this.spotlessOutDirectory;
    }

    public void setSpotlessOutDirectory(File spotlessOutDirectory) {
        this.spotlessOutDirectory = spotlessOutDirectory;
    }

    public void performActionTest() throws Exception {
        this.performAction(true);
    }

    @TaskAction
    public void performAction() throws Exception {
        this.performAction(false);
    }

    private void performAction(boolean isTest) {
        ConfigurableFileTree files = this.getProject().fileTree((Object)this.spotlessOutDirectory);
        if (files.isEmpty()) {
            this.getState().setDidWork(this.source.getDidWork());
        } else if (!isTest && this.getProject().getGradle().getTaskGraph().hasTask((Task)this.source.applyTask)) {
            this.getState().setDidWork(false);
        } else {
            final ArrayList<File> problemFiles = new ArrayList<File>();
            files.visit(new FileVisitor(){

                public void visitDir(FileVisitDetails fileVisitDetails) {
                }

                public void visitFile(FileVisitDetails fileVisitDetails) {
                    String path = fileVisitDetails.getPath();
                    File originalSource = new File(SpotlessCheck.this.getProject().getProjectDir(), path);
                    problemFiles.add(originalSource);
                }
            });
            if (!problemFiles.isEmpty()) {
                Formatter formatter = this.source.buildFormatter();
                Collections.sort(problemFiles);
                throw this.formatViolationsFor(formatter, problemFiles);
            }
        }
    }

    private GradleException formatViolationsFor(Formatter formatter, List<File> problemFiles) {
        return new GradleException(DiffMessageFormatter.builder().runToFix("Run '" + SpotlessCheck.calculateGradleCommand() + " " + this.getTaskPathPrefix() + "spotlessApply' to fix these violations.").formatter(formatter).problemFiles(problemFiles).getMessage());
    }

    private String getTaskPathPrefix() {
        return this.getProject().getPath().equals(":") ? ":" : this.getProject().getPath() + ":";
    }

    private static String calculateGradleCommand() {
        return LineEnding.nativeIsWin() ? "gradlew.bat" : "./gradlew";
    }
}

