/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessPluginPostConfigAvoidance;
import com.diffplug.gradle.spotless.SpotlessPluginPreConfigAvoidance;
import com.diffplug.spotless.SpotlessCache;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.util.GradleVersion;

public class SpotlessPlugin
implements Plugin<Project> {
    SpotlessExtension spotless;

    public void apply(Project project) {
        project.getPlugins().apply(BasePlugin.class);
        this.spotless = (SpotlessExtension)project.getExtensions().create("spotless", SpotlessExtension.class, new Object[]{project});
        Task clean = project.getTasks().getByName("clean");
        clean.doLast(unused -> SpotlessCache.clearOnce((Object)System.identityHashCode(project.getRootProject())));
        project.afterEvaluate(unused -> {
            if (this.spotless.enforceCheck) {
                if (GradleVersion.current().compareTo(SpotlessPluginPreConfigAvoidance.CONFIG_AVOIDANCE_INTRODUCED) >= 0) {
                    SpotlessPluginPostConfigAvoidance.enforceCheck(this.spotless, project);
                } else {
                    SpotlessPluginPreConfigAvoidance.enforceCheck(this.spotless, project);
                }
            }
        });
    }

    @Deprecated
    public SpotlessExtension getExtension() {
        return this.spotless;
    }

    static String capitalize(String input) {
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }
}

