/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtensionBase;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterProperties;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.markdown.FreshMarkStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.gradle.api.Action;

public class FreshMarkExtension
extends FormatExtension {
    static final String NAME = "freshmark";
    public final List<Action<Map<String, Object>>> propertyActions = new ArrayList<Action<Map<String, Object>>>();

    public FreshMarkExtension(SpotlessExtensionBase spotless) {
        super(spotless);
        this.addStep(FreshMarkStep.create(() -> {
            HashMap map = new HashMap();
            for (Action<Map<String, Object>> action : this.propertyActions) {
                action.execute(map);
            }
            return map;
        }, (Provisioner)this.provisioner()));
    }

    public void properties(Action<Map<String, Object>> action) {
        this.propertyActions.add(Objects.requireNonNull(action));
    }

    public void propertiesFile(Object ... files) {
        PluginGradlePreconditions.requireElementsNonNull(files);
        this.propertyActions.add((Action<Map<String, Object>>)((Action)map -> {
            FormatterProperties preferences = FormatterProperties.from((Iterable)this.getProject().files(files));
            preferences.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(key.toString(), value)));
        }));
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget("**/*.md");
        }
        super.setupTask(task);
    }
}

