/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.CssExtension;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.IdeHook;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessCheck;
import com.diffplug.gradle.spotless.SpotlessDiagnoseTask;
import com.diffplug.gradle.spotless.SpotlessExtensionBase;
import com.diffplug.gradle.spotless.SpotlessPlugin;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.XmlExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class SpotlessExtension
extends SpotlessExtensionBase {
    final Task rootCheckTask;
    final Task rootApplyTask;
    final Task rootDiagnoseTask;
    private static final String FILES_PROPERTY = "spotlessFiles";

    public SpotlessExtension(Project project) {
        super(project);
        this.rootCheckTask = project.task("spotlessCheck");
        this.rootCheckTask.setGroup("Verification");
        this.rootCheckTask.setDescription("Checks that sourcecode satisfies formatting steps.");
        this.rootApplyTask = project.task("spotlessApply");
        this.rootApplyTask.setGroup("Verification");
        this.rootApplyTask.setDescription("Applies code formatting steps to sourcecode in-place.");
        this.rootDiagnoseTask = project.task("spotlessDiagnose");
        this.rootDiagnoseTask.setGroup("Verification");
    }

    @Deprecated
    public void css(Action<CssExtension> closure) {
        this.configure("css", CssExtension.class, closure);
    }

    @Deprecated
    public void xml(Action<XmlExtension> closure) {
        this.configure("xml", XmlExtension.class, closure);
    }

    @Override
    protected void createFormatTasks(String name, FormatExtension formatExtension) {
        String taskName = "spotless" + SpotlessPlugin.capitalize(name);
        SpotlessTask spotlessTask = (SpotlessTask)this.project.getTasks().create(taskName, SpotlessTask.class);
        this.project.afterEvaluate(unused -> formatExtension.setupTask(spotlessTask));
        Task clean = this.project.getTasks().getByName("clean");
        spotlessTask.mustRunAfter(new Object[]{clean});
        SpotlessCheck checkTask = (SpotlessCheck)this.project.getTasks().create(taskName + "Check", SpotlessCheck.class);
        checkTask.setSpotlessOutDirectory(spotlessTask.getOutputDirectory());
        checkTask.source = spotlessTask;
        checkTask.dependsOn(new Object[]{spotlessTask});
        SpotlessApply applyTask = (SpotlessApply)this.project.getTasks().create(taskName + "Apply", SpotlessApply.class);
        applyTask.setSpotlessOutDirectory(spotlessTask.getOutputDirectory());
        applyTask.linkSource(spotlessTask);
        applyTask.dependsOn(new Object[]{spotlessTask});
        checkTask.mustRunAfter(new Object[]{applyTask});
        this.project.afterEvaluate(unused -> {
            String filePatterns;
            if (this.project.hasProperty(FILES_PROPERTY) && this.project.property(FILES_PROPERTY) instanceof String) {
                System.err.println("Spotless with -PspotlessFiles has been deprecated and will be removed. It is slow and error-prone, especially for win/unix cross-platform, and we have better options available now:");
                System.err.println("  If you are formatting just one file, try the much faster IDE hook: https://github.com/diffplug/spotless/blob/main/plugin-gradle/IDE_HOOK.md");
                System.err.println("  If you are integrating with git, try `ratchetFrom 'origin/main'`: https://github.com/diffplug/spotless/tree/main/plugin-gradle#ratchet");
                System.err.println("  If neither of these work for you, please let us know in this PR: https://github.com/diffplug/spotless/pull/602");
                filePatterns = (String)this.project.property(FILES_PROPERTY);
            } else {
                filePatterns = "";
            }
            spotlessTask.setFilePatterns(filePatterns);
        });
        this.rootCheckTask.dependsOn(new Object[]{checkTask});
        this.rootApplyTask.dependsOn(new Object[]{applyTask});
        SpotlessDiagnoseTask diagnoseTask = (SpotlessDiagnoseTask)this.project.getTasks().create(taskName + "Diagnose", SpotlessDiagnoseTask.class);
        diagnoseTask.source = spotlessTask;
        this.rootDiagnoseTask.dependsOn(new Object[]{diagnoseTask});
        diagnoseTask.mustRunAfter(new Object[]{clean});
        if (this.project.hasProperty("spotlessIdeHook")) {
            spotlessTask.setEnabled(false);
            checkTask.setEnabled(false);
            applyTask.setEnabled(false);
            this.rootApplyTask.doLast(unused -> IdeHook.performHook(spotlessTask));
        }
    }
}

