/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.base.Throwing;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessTaskBase;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCell;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

@CacheableTask
public class SpotlessTask
extends SpotlessTaskBase {
    protected String filePatterns = "";

    @Deprecated
    @Internal
    public boolean isPaddedCell() {
        return true;
    }

    @Deprecated
    public void setPaddedCell(boolean paddedCell) {
        this.getLogger().warn("Spotless warning: Padded Cell is now always on, and cannot be turned off.  Find `paddedCell(` and remove all invocations.");
    }

    @Input
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = Objects.requireNonNull(filePatterns);
    }

    @TaskAction
    public void performAction(IncrementalTaskInputs inputs) throws Exception {
        Throwing.Specific.Predicate shouldInclude;
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> target'");
        }
        if (!inputs.isIncremental()) {
            this.getLogger().info("Not incremental: removing prior outputs");
            this.getProject().delete(new Object[]{this.outputDirectory});
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        if (this.filePatterns.isEmpty()) {
            shouldInclude = file -> true;
        } else {
            Preconditions.checkArgument((this.ratchet == null ? 1 : 0) != 0, (Object)"Cannot use 'ratchetFrom' and '-PspotlessFiles' at the same time");
            String[] includePatterns = this.filePatterns.split(",");
            List compiledIncludePatterns = Arrays.stream(includePatterns).map(Pattern::compile).collect(Collectors.toList());
            shouldInclude = file -> compiledIncludePatterns.stream().anyMatch(filePattern -> filePattern.matcher(file.getAbsolutePath()).matches());
        }
        try (Formatter formatter = this.buildFormatter();){
            inputs.outOfDate(inputDetails -> {
                File input = inputDetails.getFile();
                try {
                    if (shouldInclude.test((Object)input) && input.isFile()) {
                        this.processInputFile(formatter, input);
                    }
                }
                catch (IOException e) {
                    throw Errors.asRuntime((Throwable)e);
                }
            });
        }
        inputs.removed(removedDetails -> {
            File input = removedDetails.getFile();
            try {
                if (shouldInclude.test((Object)input)) {
                    this.deletePreviousResult(input);
                }
            }
            catch (IOException e) {
                throw Errors.asRuntime((Throwable)e);
            }
        });
    }

    protected void processInputFile(Formatter formatter, File input) throws IOException {
        File output = this.getOutputFile(input);
        this.getLogger().debug("Applying format to " + input + " and writing to " + output);
        PaddedCell.DirtyState dirtyState = this.ratchet != null && this.ratchet.isClean(this.getProject(), this.rootTreeSha, input) ? PaddedCell.isClean() : PaddedCell.calculateDirtyState((Formatter)formatter, (File)input);
        if (dirtyState.isClean()) {
            Files.deleteIfExists(output.toPath());
        } else if (dirtyState.didNotConverge()) {
            this.getLogger().warn("Skipping '" + input + "' because it does not converge.  Run `spotlessDiagnose` to understand why");
        } else {
            Path parentDir = output.toPath().getParent();
            if (parentDir == null) {
                throw new IllegalStateException("Every file has a parent folder.");
            }
            Files.createDirectories(parentDir, new FileAttribute[0]);
            dirtyState.writeCanonicalTo(output);
        }
    }

    protected void deletePreviousResult(File input) throws IOException {
        File output = this.getOutputFile(input);
        if (output.isDirectory()) {
            Files.walk(output.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        } else {
            Files.deleteIfExists(output.toPath());
        }
    }

    private File getOutputFile(File input) {
        String outputFileName = FormatExtension.relativize(this.getProject().getProjectDir(), input);
        if (outputFileName == null) {
            throw new IllegalArgumentException(StringPrinter.buildString(printer -> {
                printer.println("Spotless error! All target files must be within the project root. In project " + this.getProject().getPath());
                printer.println("  root dir: " + this.getProject().getProjectDir().getAbsolutePath());
                printer.println("    target: " + input.getAbsolutePath());
            }));
        }
        return new File(this.outputDirectory, outputFileName);
    }
}

