/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Throwing;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Formatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public class SpotlessTaskModern
extends SpotlessTask {
    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @InputFiles
    public FileCollection getTarget() {
        return super.getTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public void performAction(InputChanges inputs) throws Exception {
        Throwing.Specific.Predicate shouldInclude;
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> target'");
        }
        if (!inputs.isIncremental()) {
            this.getLogger().info("Not incremental: removing prior outputs");
            this.getProject().delete(new Object[]{this.outputDirectory});
            Files.createDirectories(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
        if (this.filePatterns.isEmpty()) {
            shouldInclude = file -> true;
        } else {
            Preconditions.checkArgument((this.ratchet == null ? 1 : 0) != 0, (Object)"Cannot use 'ratchetFrom' and '-PspotlessFiles' at the same time");
            String[] includePatterns = this.filePatterns.split(",");
            List compiledIncludePatterns = Arrays.stream(includePatterns).map(Pattern::compile).collect(Collectors.toList());
            shouldInclude = file -> compiledIncludePatterns.stream().anyMatch(filePattern -> filePattern.matcher(file.getAbsolutePath()).matches());
        }
        try (Formatter formatter = this.buildFormatter();){
            for (FileChange fileChange : inputs.getFileChanges(this.target)) {
                File input = fileChange.getFile();
                if (fileChange.getChangeType() == ChangeType.REMOVED) {
                    try {
                        if (!shouldInclude.test((Object)input)) continue;
                        this.deletePreviousResult(input);
                        continue;
                    }
                    catch (IOException e) {
                        throw Errors.asRuntime((Throwable)e);
                    }
                }
                try {
                    if (!shouldInclude.test((Object)input) || !input.isFile()) continue;
                    this.processInputFile(formatter, input);
                }
                catch (IOException e) {
                    throw Errors.asRuntime((Throwable)e);
                    return;
                }
            }
        }
    }
}

