/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.io.Files;
import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class RegisterDependenciesTask
extends DefaultTask {
    static final String TASK_NAME = "spotlessInternalRegisterDependencies";
    private List<SpotlessTask> tasks = new ArrayList<SpotlessTask>();
    File unitOutput;
    GradleProvisioner.RootProvisioner rootProvisioner;
    GitRatchetGradle gitRatchet = new GitRatchetGradle();

    @Input
    public List<FormatterStep> getSteps() {
        ArrayList<FormatterStep> allSteps = new ArrayList<FormatterStep>();
        TaskExecutionGraph taskGraph = this.getProject().getGradle().getTaskGraph();
        for (SpotlessTask task : this.tasks) {
            if (!taskGraph.hasTask((Task)task)) continue;
            allSteps.addAll(task.getSteps());
        }
        return allSteps;
    }

    @Internal
    public List<SpotlessTask> getTasks() {
        return this.tasks;
    }

    void hookSubprojectTask(SpotlessTask task) {
        this.tasks.add(task);
        task.dependsOn(new Object[]{this});
    }

    @OutputFile
    public File getUnitOutput() {
        return this.unitOutput;
    }

    @Internal
    public GradleProvisioner.RootProvisioner getRootProvisioner() {
        return this.rootProvisioner;
    }

    void setup() {
        Preconditions.checkArgument((this.getProject().getRootProject() == this.getProject() ? 1 : 0) != 0, (Object)"Can only be used on the root project");
        this.unitOutput = new File(this.getProject().getBuildDir(), "tmp/spotless-register-dependencies");
        this.rootProvisioner = new GradleProvisioner.RootProvisioner(this.getProject());
        this.getProject().getGradle().buildFinished(new Closure(null){

            @SuppressFBWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"})
            public Object doCall() {
                RegisterDependenciesTask.this.gitRatchet.close();
                return null;
            }
        });
    }

    @TaskAction
    public void trivialFunction() throws IOException {
        Files.createParentDirs((File)this.unitOutput);
        Files.write((CharSequence)Integer.toString(this.getSteps().size()), (File)this.unitOutput, (Charset)StandardCharsets.UTF_8);
    }

    @Internal
    GitRatchetGradle getGitRatchet() {
        return this.gitRatchet;
    }
}

