/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import com.diffplug.spotless.npm.TsConfigFileType;
import com.diffplug.spotless.npm.TsFmtFormatterStep;
import com.diffplug.spotless.npm.TypedTsFmtConfigFile;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public class TypescriptExtension
extends FormatExtension {
    static final String NAME = "typescript";

    public TypescriptExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public TypescriptFormatExtension tsfmt() {
        return this.tsfmt(TsFmtFormatterStep.defaultDevDependencies());
    }

    public TypescriptFormatExtension tsfmt(String version) {
        return this.tsfmt(TsFmtFormatterStep.defaultDevDependenciesWithTsFmt((String)version));
    }

    public TypescriptFormatExtension tsfmt(Map<String, String> devDependencies) {
        TypescriptFormatExtension tsfmt = new TypescriptFormatExtension(devDependencies);
        this.addStep(tsfmt.createStep());
        return tsfmt;
    }

    @Override
    public FormatExtension.PrettierConfig prettier() {
        return this.prettier(PrettierFormatterStep.defaultDevDependencies());
    }

    @Override
    public FormatExtension.PrettierConfig prettier(String version) {
        return this.prettier(PrettierFormatterStep.defaultDevDependenciesWithPrettier((String)version));
    }

    @Override
    public FormatExtension.PrettierConfig prettier(Map<String, String> devDependencies) {
        TypescriptPrettierConfig prettierConfig = new TypescriptPrettierConfig(devDependencies);
        this.addStep(((FormatExtension.PrettierConfig)prettierConfig).createStep());
        return prettierConfig;
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            throw this.noDefaultTargetException();
        }
        super.setupTask(task);
    }

    public class TypescriptPrettierConfig
    extends FormatExtension.PrettierConfig {
        TypescriptPrettierConfig(Map<String, String> devDependencies) {
            super(devDependencies);
        }

        @Override
        FormatterStep createStep() {
            this.fixParserToTypescript();
            return super.createStep();
        }

        private void fixParserToTypescript() {
            if (this.prettierConfig == null) {
                this.prettierConfig = Collections.singletonMap("parser", TypescriptExtension.NAME);
            } else {
                String replaced = this.prettierConfig.put("parser", TypescriptExtension.NAME);
                if (replaced != null) {
                    TypescriptExtension.this.getProject().getLogger().warn("overriding parser option to 'typescript'. Was set to '{}'", (Object)replaced);
                }
            }
        }
    }

    public class TypescriptFormatExtension
    extends FormatExtension.NpmStepConfig<TypescriptFormatExtension> {
        private Map<String, Object> config = Collections.emptyMap();
        @Nullable
        TsConfigFileType configFileType = null;
        @Nullable
        Object configFilePath = null;
        private final Map<String, String> devDependencies;

        TypescriptFormatExtension(Map<String, String> devDependencies) {
            this.devDependencies = Objects.requireNonNull(devDependencies);
        }

        public void config(Map<String, Object> config) {
            this.config = new TreeMap<String, Object>(Objects.requireNonNull(config));
            TypescriptExtension.this.replaceStep(this.createStep());
        }

        public void tsconfigFile(Object path) {
            this.configFile(TsConfigFileType.TSCONFIG, path);
        }

        public void tslintFile(Object path) {
            this.configFile(TsConfigFileType.TSLINT, path);
        }

        public void vscodeFile(Object path) {
            this.configFile(TsConfigFileType.VSCODE, path);
        }

        public void tsfmtFile(Object path) {
            this.configFile(TsConfigFileType.TSFMT, path);
        }

        private void configFile(TsConfigFileType filetype, Object path) {
            this.configFileType = Objects.requireNonNull(filetype);
            this.configFilePath = Objects.requireNonNull(path);
            TypescriptExtension.this.replaceStep(this.createStep());
        }

        @Override
        public FormatterStep createStep() {
            Project project = TypescriptExtension.this.getProject();
            return TsFmtFormatterStep.create(this.devDependencies, (Provisioner)TypescriptExtension.this.provisioner(), (File)project.getBuildDir(), (File)this.npmFileOrNull(), (TypedTsFmtConfigFile)this.typedConfigFile(), this.config);
        }

        private TypedTsFmtConfigFile typedConfigFile() {
            if (this.configFileType != null && this.configFilePath != null) {
                return new TypedTsFmtConfigFile(this.configFileType, TypescriptExtension.this.getProject().file(this.configFilePath));
            }
            return null;
        }
    }
}

