/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.collect.ImmutableSortedMap;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.DiktatStep;
import com.diffplug.spotless.kotlin.KtLintStep;
import com.diffplug.spotless.kotlin.KtfmtStep;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class KotlinGradleExtension
extends FormatExtension {
    private static final String GRADLE_KOTLIN_DSL_FILE_EXTENSION = "*.gradle.kts";
    static final String NAME = "kotlinGradle";

    @Inject
    public KotlinGradleExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public KotlinFormatExtension ktlint(String version) {
        Objects.requireNonNull(version, "version");
        return new KotlinFormatExtension(version, Collections.emptyMap());
    }

    public KotlinFormatExtension ktlint() {
        return this.ktlint(KtLintStep.defaultVersion());
    }

    public KtfmtConfig ktfmt() {
        return this.ktfmt(KtfmtStep.defaultVersion());
    }

    public KtfmtConfig ktfmt(String version) {
        Objects.requireNonNull(version);
        return new KtfmtConfig(version);
    }

    public DiktatFormatExtension diktat(String version) {
        Objects.requireNonNull(version, "version");
        return new DiktatFormatExtension(version);
    }

    public DiktatFormatExtension diktat() {
        return this.diktat(DiktatStep.defaultVersionDiktat());
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget(GRADLE_KOTLIN_DSL_FILE_EXTENSION);
        }
        super.setupTask(task);
    }

    public class DiktatFormatExtension {
        private final String version;
        private FileSignature config;

        DiktatFormatExtension(String version) {
            this.version = version;
            KotlinGradleExtension.this.addStep(this.createStep());
        }

        public DiktatFormatExtension configFile(Object file) throws IOException {
            this.config = file == null ? null : FileSignature.signAsList((File[])new File[]{KotlinGradleExtension.this.getProject().file(file)});
            KotlinGradleExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return DiktatStep.createForScript((String)this.version, (Provisioner)KotlinGradleExtension.this.provisioner(), (FileSignature)this.config);
        }
    }

    public class KtfmtConfig {
        final String version;
        KtfmtStep.Style style;

        KtfmtConfig(String version) {
            this.version = Objects.requireNonNull(version);
            this.style = KtfmtStep.Style.DEFAULT;
            KotlinGradleExtension.this.addStep(this.createStep());
        }

        public void dropboxStyle() {
            this.style = KtfmtStep.Style.DROPBOX;
            KotlinGradleExtension.this.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            return KtfmtStep.create((String)this.version, (Provisioner)KotlinGradleExtension.this.provisioner(), (KtfmtStep.Style)this.style);
        }
    }

    public class KotlinFormatExtension {
        private final String version;
        private Map<String, String> userData;

        KotlinFormatExtension(String version, Map<String, String> config) {
            this.version = version;
            this.userData = config;
            KotlinGradleExtension.this.addStep(this.createStep());
        }

        public void userData(Map<String, String> userData) {
            this.userData = ImmutableSortedMap.copyOf(userData);
            KotlinGradleExtension.this.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            return KtLintStep.createForScript((String)this.version, (Provisioner)KotlinGradleExtension.this.provisioner(), this.userData);
        }
    }
}

