/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.scala.ScalaFmtStep;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class ScalaExtension
extends FormatExtension {
    static final String NAME = "scala";

    public ScalaExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public ScalaFmtConfig scalafmt() {
        return this.scalafmt(ScalaFmtStep.defaultVersion());
    }

    public ScalaFmtConfig scalafmt(String version) {
        return new ScalaFmtConfig(version);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPlugin == null) {
                throw new GradleException("You must either specify 'target' manually or apply the 'scala' plugin.");
            }
            ConfigurableFileCollection union = this.getProject().files(new Object[0]);
            for (SourceSet sourceSet : javaPlugin.getSourceSets()) {
                union = union.plus(sourceSet.getAllSource().filter(file -> {
                    String name = file.getName();
                    return name.endsWith(".scala") || name.endsWith(".sc");
                }));
            }
            this.target = union;
        }
        super.setupTask(task);
    }

    public class ScalaFmtConfig {
        final String version;
        @Nullable
        Object configFile;

        ScalaFmtConfig(String version) {
            this.version = Objects.requireNonNull(version);
            ScalaExtension.this.addStep(this.createStep());
        }

        public void configFile(Object configFile) {
            this.configFile = Objects.requireNonNull(configFile);
            ScalaExtension.this.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            File resolvedConfigFile = this.configFile == null ? null : ScalaExtension.this.getProject().file(this.configFile);
            return ScalaFmtStep.create((String)this.version, (Provisioner)ScalaExtension.this.provisioner(), (File)resolvedConfigFile);
        }
    }
}

