/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public class SpotlessApply
extends DefaultTask {
    private SpotlessTask source;
    private File spotlessOutDirectory;

    void linkSource(SpotlessTask source) {
        this.source = source;
        source.applyTask = this;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputDirectory
    public File getSpotlessOutDirectory() {
        return this.spotlessOutDirectory;
    }

    public void setSpotlessOutDirectory(File spotlessOutDirectory) {
        this.spotlessOutDirectory = spotlessOutDirectory;
    }

    @TaskAction
    public void performAction() {
        ConfigurableFileTree files = this.getProject().fileTree((Object)this.spotlessOutDirectory);
        if (files.isEmpty()) {
            this.getState().setDidWork(this.source.getDidWork());
        } else {
            files.visit(new FileVisitor(){

                public void visitDir(FileVisitDetails fileVisitDetails) {
                }

                public void visitFile(FileVisitDetails fileVisitDetails) {
                    String path = fileVisitDetails.getPath();
                    File originalSource = new File(SpotlessApply.this.getProject().getProjectDir(), path);
                    try {
                        SpotlessApply.this.getLogger().debug("Copying " + fileVisitDetails.getFile() + " to " + originalSource);
                        Files.copy(fileVisitDetails.getFile().toPath(), originalSource.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }
}

