/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.KtLintStep;
import com.diffplug.spotless.kotlin.KtfmtStep;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class KotlinExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense {
    static final String NAME = "kotlin";

    @Inject
    public KotlinExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, "(package |@file)");
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, "(package |@file)");
    }

    public KotlinFormatExtension ktlint(String version) {
        Objects.requireNonNull(version);
        return new KotlinFormatExtension(version, Collections.emptyMap());
    }

    public KotlinFormatExtension ktlint() {
        return this.ktlint(KtLintStep.defaultVersion());
    }

    public KtfmtConfig ktfmt() {
        return this.ktfmt(KtfmtStep.defaultVersion());
    }

    public KtfmtConfig ktfmt(String version) {
        Objects.requireNonNull(version);
        return new KtfmtConfig(version);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            JavaPluginConvention javaPlugin = (JavaPluginConvention)this.getProject().getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPlugin == null) {
                throw new GradleException("You must either specify 'target' manually or apply a kotlin plugin.");
            }
            ConfigurableFileCollection union = this.getProject().files(new Object[0]);
            for (SourceSet sourceSet : javaPlugin.getSourceSets()) {
                union = union.plus(sourceSet.getAllSource().filter(file -> {
                    String name = file.getName();
                    return name.endsWith(".kt") || name.endsWith(".kts");
                }));
            }
            this.target = union;
        }
        super.setupTask(task);
    }

    public class KtfmtConfig {
        final String version;
        KtfmtStep.Style style;

        KtfmtConfig(String version) {
            this.version = Objects.requireNonNull(version);
            this.style = KtfmtStep.Style.DEFAULT;
            KotlinExtension.this.addStep(this.createStep());
        }

        public void dropboxStyle() {
            this.style = KtfmtStep.Style.DROPBOX;
            KotlinExtension.this.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            return KtfmtStep.create((String)this.version, (Provisioner)KotlinExtension.this.provisioner(), (KtfmtStep.Style)this.style);
        }
    }

    public class KotlinFormatExtension {
        private final String version;
        private Map<String, String> userData;

        KotlinFormatExtension(String version, Map<String, String> config) {
            this.version = version;
            this.userData = config;
            KotlinExtension.this.addStep(this.createStep());
        }

        public void userData(Map<String, String> userData) {
            this.userData = userData;
            KotlinExtension.this.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            return KtLintStep.create((String)this.version, (Provisioner)KotlinExtension.this.provisioner(), this.userData);
        }
    }
}

