/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.IdeHook;
import com.diffplug.gradle.spotless.RegisterDependenciesTask;
import com.diffplug.gradle.spotless.SpotlessApply;
import com.diffplug.gradle.spotless.SpotlessCheck;
import com.diffplug.gradle.spotless.SpotlessDiagnoseTask;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessPlugin;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskImpl;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class SpotlessExtensionImpl
extends SpotlessExtension {
    private final TaskProvider<RegisterDependenciesTask> registerDependenciesTask;
    final TaskProvider<?> rootCheckTask;
    final TaskProvider<?> rootApplyTask;
    final TaskProvider<?> rootDiagnoseTask;

    public SpotlessExtensionImpl(Project project) {
        super(project);
        this.rootCheckTask = project.getTasks().register("spotlessCheck", task -> {
            task.setGroup("Verification");
            task.setDescription("Checks that sourcecode satisfies formatting steps.");
        });
        this.rootApplyTask = project.getTasks().register("spotlessApply", task -> {
            task.setGroup("Verification");
            task.setDescription("Applies code formatting steps to sourcecode in-place.");
        });
        this.rootDiagnoseTask = project.getTasks().register("spotlessDiagnose", task -> task.setGroup("Verification"));
        this.registerDependenciesTask = this.findRegisterDepsTask();
        project.afterEvaluate(unused -> {
            if (this.enforceCheck) {
                try {
                    project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{this.rootCheckTask}));
                }
                catch (UnknownTaskException unknownTaskException) {
                    // empty catch block
                }
            }
        });
    }

    private TaskProvider<RegisterDependenciesTask> findRegisterDepsTask() {
        try {
            return this.findRegisterDepsTask("spotlessInternalRegisterDependencies");
        }
        catch (Exception e) {
            return this.findRegisterDepsTask("spotlessInternalRegisterDependencies" + System.identityHashCode(RegisterDependenciesTask.class));
        }
    }

    private TaskProvider<RegisterDependenciesTask> findRegisterDepsTask(String taskName) {
        TaskContainer rootProjectTasks = this.project.getRootProject().getTasks();
        if (!rootProjectTasks.getNames().contains(taskName)) {
            return rootProjectTasks.register(taskName, RegisterDependenciesTask.class, RegisterDependenciesTask::setup);
        }
        return rootProjectTasks.named(taskName, RegisterDependenciesTask.class);
    }

    @Override
    RegisterDependenciesTask getRegisterDependenciesTask() {
        return (RegisterDependenciesTask)((Object)this.registerDependenciesTask.get());
    }

    @Override
    protected void createFormatTasks(String name, FormatExtension formatExtension) {
        boolean isIdeHook = this.project.hasProperty("spotlessIdeHook");
        TaskContainer tasks = this.project.getTasks();
        String taskName = "spotless" + SpotlessPlugin.capitalize(name);
        TaskProvider spotlessTask = tasks.register(taskName, SpotlessTaskImpl.class, task -> {
            task.init((Provider<SpotlessTaskService>)this.getRegisterDependenciesTask().getTaskService());
            task.setEnabled(!isIdeHook);
        });
        SpotlessPlugin.taskMustRunAfterClean(this.project, spotlessTask);
        this.project.afterEvaluate(unused -> spotlessTask.configure(task -> {
            for (Action<FormatExtension> lazyAction : formatExtension.lazyActions) {
                lazyAction.execute((Object)formatExtension);
            }
            formatExtension.setupTask((SpotlessTask)((Object)((Object)task)));
        }));
        TaskProvider applyTask = tasks.register(taskName + "Apply", SpotlessApply.class, task -> {
            task.init((SpotlessTaskImpl)((Object)((Object)spotlessTask.get())));
            task.setEnabled(!isIdeHook);
            task.dependsOn(new Object[]{spotlessTask});
        });
        this.rootApplyTask.configure(task -> {
            task.dependsOn(new Object[]{applyTask});
            if (isIdeHook) {
                task.doLast(unused -> IdeHook.performHook((SpotlessTaskImpl)((Object)((Object)((Object)spotlessTask.get())))));
            }
        });
        TaskProvider checkTask = tasks.register(taskName + "Check", SpotlessCheck.class, task -> {
            SpotlessTaskImpl source = (SpotlessTaskImpl)((Object)((Object)spotlessTask.get()));
            task.init(source);
            task.setEnabled(!isIdeHook);
            task.dependsOn(new Object[]{source});
            task.mustRunAfter(new Object[]{applyTask});
        });
        this.rootCheckTask.configure(task -> task.dependsOn(new Object[]{checkTask}));
        TaskProvider diagnoseTask = tasks.register(taskName + "Diagnose", SpotlessDiagnoseTask.class, task -> {
            task.source = (SpotlessTask)((Object)((Object)spotlessTask.get()));
        });
        SpotlessPlugin.taskMustRunAfterClean(this.project, diagnoseTask);
        this.rootDiagnoseTask.configure(task -> task.dependsOn(new Object[]{diagnoseTask}));
    }
}

